/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import com.hierynomus.sshj.common.RemoteAddressProvider;
import com.hierynomus.sshj.key.KeyAlgorithm;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.SSHPacketHandler;
import net.schmizz.sshj.transport.DisconnectListener;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.AlgorithmsVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;

public interface Transport
extends SSHPacketHandler,
RemoteAddressProvider {
    public void init(String var1, int var2, InputStream var3, OutputStream var4) throws TransportException;

    public void addHostKeyVerifier(HostKeyVerifier var1);

    public void addAlgorithmsVerifier(AlgorithmsVerifier var1);

    public void doKex() throws TransportException;

    public boolean isKeyExchangeRequired();

    public String getClientVersion();

    public Config getConfig();

    public int getTimeoutMs();

    public void setTimeoutMs(int var1);

    public String getRemoteHost();

    public int getRemotePort();

    public String getServerVersion();

    public byte[] getSessionID();

    public Service getService();

    public void reqService(Service var1) throws TransportException;

    public void setService(Service var1);

    public boolean isAuthenticated();

    public void setAuthenticated();

    public long sendUnimplemented() throws TransportException;

    public boolean isRunning();

    public void join() throws TransportException;

    public void join(int var1, TimeUnit var2) throws TransportException;

    public void disconnect();

    public void disconnect(DisconnectReason var1);

    public void disconnect(DisconnectReason var1, String var2);

    public long write(SSHPacket var1) throws TransportException;

    public void setDisconnectListener(DisconnectListener var1);

    public DisconnectListener getDisconnectListener();

    public void die(Exception var1);

    public KeyAlgorithm getHostKeyAlgorithm();

    public List<KeyAlgorithm> getClientKeyAlgorithms(KeyType var1) throws TransportException;
}

