/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.ScopeAnnotation;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.util.Classes;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.inject.Qualifier;
import javax.inject.Scope;

public class Annotations {
    private static final LoadingCache<Class<? extends Annotation>, Annotation> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<? extends Annotation>, Annotation>(){

        @Override
        public Annotation load(Class<? extends Annotation> input) {
            return Annotations.generateAnnotationImpl(input);
        }
    });
    private static final Joiner.MapJoiner JOINER = Joiner.on(", ").withKeyValueSeparator("=");
    private static final Function<Object, String> DEEP_TO_STRING_FN = new Function<Object, String>(){

        @Override
        public String apply(Object arg) {
            String s = Arrays.deepToString(new Object[]{arg});
            return s.substring(1, s.length() - 1);
        }
    };
    private static final boolean QUOTE_MEMBER_VALUES = Annotations.determineWhetherToQuote();
    private static final AnnotationChecker scopeChecker = new AnnotationChecker(Arrays.asList(ScopeAnnotation.class, Scope.class));
    private static final AnnotationChecker bindingAnnotationChecker = new AnnotationChecker(Arrays.asList(BindingAnnotation.class, Qualifier.class));

    public static boolean isMarker(Class<? extends Annotation> annotationType) {
        return annotationType.getDeclaredMethods().length == 0;
    }

    public static boolean isAllDefaultMethods(Class<? extends Annotation> annotationType) {
        boolean hasMethods = false;
        for (Method m : annotationType.getDeclaredMethods()) {
            hasMethods = true;
            if (m.getDefaultValue() != null) continue;
            return false;
        }
        return hasMethods;
    }

    public static <T extends Annotation> T generateAnnotation(Class<T> annotationType) {
        Preconditions.checkState(Annotations.isAllDefaultMethods(annotationType), "%s is not all default methods", annotationType);
        return (T)cache.getUnchecked(annotationType);
    }

    private static <T extends Annotation> T generateAnnotationImpl(final Class<T> annotationType) {
        final ImmutableMap<String, Object> members2 = Annotations.resolveMembers(annotationType);
        return (T)((Annotation)annotationType.cast(Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy2, Method method, Object[] args2) throws Exception {
                String name2 = method.getName();
                if (name2.equals("annotationType")) {
                    return annotationType;
                }
                if (name2.equals("toString")) {
                    return Annotations.annotationToString(annotationType, members2);
                }
                if (name2.equals("hashCode")) {
                    return Annotations.annotationHashCode(annotationType, members2);
                }
                if (name2.equals("equals")) {
                    return Annotations.annotationEquals(annotationType, members2, args2[0]);
                }
                return members2.get(name2);
            }
        })));
    }

    private static ImmutableMap<String, Object> resolveMembers(Class<? extends Annotation> annotationType) {
        ImmutableMap.Builder<String, Object> result2 = ImmutableMap.builder();
        for (Method method : annotationType.getDeclaredMethods()) {
            result2.put(method.getName(), method.getDefaultValue());
        }
        return result2.build();
    }

    private static boolean annotationEquals(Class<? extends Annotation> type2, Map<String, Object> members2, Object other) throws Exception {
        if (!type2.isInstance(other)) {
            return false;
        }
        for (Method method : type2.getDeclaredMethods()) {
            String name2 = method.getName();
            if (Arrays.deepEquals(new Object[]{method.invoke(other, new Object[0])}, new Object[]{members2.get(name2)})) continue;
            return false;
        }
        return true;
    }

    private static int annotationHashCode(Class<? extends Annotation> type2, Map<String, Object> members2) throws Exception {
        int result2 = 0;
        for (Method method : type2.getDeclaredMethods()) {
            String name2 = method.getName();
            Object value2 = members2.get(name2);
            result2 += 127 * name2.hashCode() ^ Arrays.deepHashCode(new Object[]{value2}) - 31;
        }
        return result2;
    }

    private static String annotationToString(Class<? extends Annotation> type2, Map<String, Object> members2) throws Exception {
        StringBuilder sb = new StringBuilder().append("@").append(type2.getName()).append("(");
        JOINER.appendTo(sb, Maps.transformValues(members2, DEEP_TO_STRING_FN));
        return sb.append(")").toString();
    }

    public static boolean isRetainedAtRuntime(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return retention != null && retention.value() == RetentionPolicy.RUNTIME;
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Class<?> implementation2) {
        return Annotations.findScopeAnnotation(errors, implementation2.getAnnotations());
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Annotation[] annotations2) {
        Class<? extends Annotation> found = null;
        for (Annotation annotation2 : annotations2) {
            Class<? extends Annotation> annotationType = annotation2.annotationType();
            if (!Annotations.isScopeAnnotation(annotationType)) continue;
            if (found != null) {
                errors.duplicateScopeAnnotations(found, annotationType);
                continue;
            }
            found = annotationType;
        }
        return found;
    }

    static boolean containsComponentAnnotation(Annotation[] annotations2) {
        for (Annotation annotation2 : annotations2) {
            if (!annotation2.annotationType().getSimpleName().equals("Component")) continue;
            return true;
        }
        return false;
    }

    public static String memberValueString(String value2) {
        return QUOTE_MEMBER_VALUES ? "\"" + value2 + "\"" : value2;
    }

    @TestAnnotation(value="determineWhetherToQuote")
    private static boolean determineWhetherToQuote() {
        try {
            String annotation2 = Annotations.class.getDeclaredMethod("determineWhetherToQuote", new Class[0]).getAnnotation(TestAnnotation.class).toString();
            return annotation2.contains("\"determineWhetherToQuote\"");
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        return scopeChecker.hasAnnotations(annotationType);
    }

    public static void checkForMisplacedScopeAnnotations(Class<?> type2, Object source, Errors errors) {
        if (Classes.isConcrete(type2)) {
            return;
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, type2);
        if (scopeAnnotation != null && !Annotations.containsComponentAnnotation(type2.getAnnotations())) {
            errors.withSource(type2).scopeAnnotationOnAbstractType(scopeAnnotation, type2, source);
        }
    }

    public static Key<?> getKey(TypeLiteral<?> type2, Member member2, Annotation[] annotations2, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        Annotation found = Annotations.findBindingAnnotation(errors, member2, annotations2);
        errors.throwIfNewErrors(numErrorsBefore);
        return found == null ? Key.get(type2) : Key.get(type2, found);
    }

    public static Annotation findBindingAnnotation(Errors errors, Member member2, Annotation[] annotations2) {
        Annotation found = null;
        for (Annotation annotation2 : annotations2) {
            Class<? extends Annotation> annotationType = annotation2.annotationType();
            if (!Annotations.isBindingAnnotation(annotationType)) continue;
            if (found != null) {
                errors.duplicateBindingAnnotations(member2, found.annotationType(), annotationType);
                continue;
            }
            found = annotation2;
        }
        return found;
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return bindingAnnotationChecker.hasAnnotations(annotationType);
    }

    public static Annotation canonicalizeIfNamed(Annotation annotation2) {
        if (annotation2 instanceof javax.inject.Named) {
            return Names.named(((javax.inject.Named)annotation2).value());
        }
        return annotation2;
    }

    public static Class<? extends Annotation> canonicalizeIfNamed(Class<? extends Annotation> annotationType) {
        if (annotationType == javax.inject.Named.class) {
            return Named.class;
        }
        return annotationType;
    }

    public static String nameOf(Key<?> key) {
        Annotation annotation2 = key.getAnnotation();
        Class<Annotation> annotationType = key.getAnnotationType();
        if (annotation2 != null && !Annotations.isMarker(annotationType)) {
            return key.getAnnotation().toString();
        }
        if (key.getAnnotationType() != null) {
            return "@" + key.getAnnotationType().getName();
        }
        return "";
    }

    static class AnnotationChecker {
        private final Collection<Class<? extends Annotation>> annotationTypes;
        private CacheLoader<Class<? extends Annotation>, Boolean> hasAnnotations = new CacheLoader<Class<? extends Annotation>, Boolean>(){

            @Override
            public Boolean load(Class<? extends Annotation> annotationType) {
                for (Annotation annotation2 : annotationType.getAnnotations()) {
                    if (!AnnotationChecker.this.annotationTypes.contains(annotation2.annotationType())) continue;
                    return true;
                }
                return false;
            }
        };
        final LoadingCache<Class<? extends Annotation>, Boolean> cache = CacheBuilder.newBuilder().weakKeys().build(this.hasAnnotations);

        AnnotationChecker(Collection<Class<? extends Annotation>> annotationTypes) {
            this.annotationTypes = annotationTypes;
        }

        boolean hasAnnotations(Class<? extends Annotation> annotated) {
            return this.cache.getUnchecked(annotated);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestAnnotation {
        public String value();
    }
}

