/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.inject.internal.ConstructionContext;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.internal.ProvisionListenerStackCallback;
import com.google.inject.spi.Dependency;
import javax.inject.Provider;

abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    protected final Object source;

    ProviderInternalFactory(Object source) {
        this.source = Preconditions.checkNotNull(source, "source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T circularGet(final Provider<? extends T> provider, InternalContext context2, final Dependency<?> dependency, ProvisionListenerStackCallback<T> provisionCallback) throws InternalProvisionException {
        final ConstructionContext constructionContext = context2.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            Class<?> expectedType2 = dependency.getKey().getTypeLiteral().getRawType();
            Object proxyType = constructionContext.createProxy(context2.getInjectorOptions(), expectedType2);
            return (T)proxyType;
        }
        constructionContext.startConstruction();
        try {
            if (provisionCallback == null) {
                T t = this.provision(provider, dependency, constructionContext);
                return t;
            }
            T t = provisionCallback.provision(context2, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws InternalProvisionException {
                    return ProviderInternalFactory.this.provision(provider, dependency, constructionContext);
                }
            });
            return t;
        }
        finally {
            constructionContext.removeCurrentReference();
            constructionContext.finishConstruction();
        }
    }

    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        T t = provider.get();
        if (t == null && !dependency.isNullable()) {
            InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
        }
        constructionContext.setProxyDelegates(t);
        return t;
    }
}

