/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class BitField {
    private final int _mask;
    private final int _shift_count;

    public BitField(int mask) {
        this._mask = mask;
        this._shift_count = mask == 0 ? 0 : Integer.numberOfTrailingZeros(mask);
    }

    public int getValue(int holder2) {
        return this.getRawValue(holder2) >> this._shift_count;
    }

    public short getShortValue(short holder2) {
        return (short)this.getValue(holder2);
    }

    public int getRawValue(int holder2) {
        return holder2 & this._mask;
    }

    public short getShortRawValue(short holder2) {
        return (short)this.getRawValue(holder2);
    }

    public boolean isSet(int holder2) {
        return (holder2 & this._mask) != 0;
    }

    public boolean isAllSet(int holder2) {
        return (holder2 & this._mask) == this._mask;
    }

    public int setValue(int holder2, int value2) {
        return holder2 & ~this._mask | value2 << this._shift_count & this._mask;
    }

    public short setShortValue(short holder2, short value2) {
        return (short)this.setValue(holder2, value2);
    }

    public int clear(int holder2) {
        return holder2 & ~this._mask;
    }

    public short clearShort(short holder2) {
        return (short)this.clear(holder2);
    }

    public byte clearByte(byte holder2) {
        return (byte)this.clear(holder2);
    }

    public int set(int holder2) {
        return holder2 | this._mask;
    }

    public short setShort(short holder2) {
        return (short)this.set(holder2);
    }

    public byte setByte(byte holder2) {
        return (byte)this.set(holder2);
    }

    public int setBoolean(int holder2, boolean flag) {
        return flag ? this.set(holder2) : this.clear(holder2);
    }

    public short setShortBoolean(short holder2, boolean flag) {
        return flag ? this.setShort(holder2) : this.clearShort(holder2);
    }

    public byte setByteBoolean(byte holder2, boolean flag) {
        return flag ? this.setByte(holder2) : this.clearByte(holder2);
    }
}

