/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap = new HashMap<String, CookieAttributeHandler>(10);

    public void registerAttribHandler(String name2, CookieAttributeHandler handler2) {
        Args.notNull(name2, "Attribute name");
        Args.notNull(handler2, "Attribute handler");
        this.attribHandlerMap.put(name2, handler2);
    }

    protected CookieAttributeHandler findAttribHandler(String name2) {
        return this.attribHandlerMap.get(name2);
    }

    protected CookieAttributeHandler getAttribHandler(String name2) {
        CookieAttributeHandler handler2 = this.findAttribHandler(name2);
        if (handler2 == null) {
            throw new IllegalStateException("Handler not registered for " + name2 + " attribute.");
        }
        return handler2;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

