/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.MetadataParseException;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=MetadataReader.class)
public class DefaultMetadataReader
implements MetadataReader {
    @Override
    public Metadata read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        Metadata metadata2 = this.read(ReaderFactory.newXmlReader(input), options);
        return metadata2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Metadata read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            Metadata metadata2 = new MetadataXpp3Reader().read(in, this.isStrict(options));
            return metadata2;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Metadata read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = input;){
            Metadata metadata2 = new MetadataXpp3Reader().read(in, this.isStrict(options));
            return metadata2;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value2 = options != null ? (Object)options.get("org.apache.maven.artifact.repository.metadata.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }
}

