/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.DefaultExecutionEvent;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ExecutionEventCatapult.class)
public class DefaultExecutionEventCatapult
implements ExecutionEventCatapult {
    @Override
    public void fire(ExecutionEvent.Type eventType, MavenSession session2, MojoExecution mojoExecution) {
        this.fire(eventType, session2, mojoExecution, null);
    }

    @Override
    public void fire(ExecutionEvent.Type eventType, MavenSession session2, MojoExecution mojoExecution, Exception exception) {
        ExecutionListener listener = session2.getRequest().getExecutionListener();
        if (listener != null) {
            DefaultExecutionEvent event = new DefaultExecutionEvent(eventType, session2, mojoExecution, exception);
            switch (eventType) {
                case ProjectDiscoveryStarted: {
                    listener.projectDiscoveryStarted(event);
                    break;
                }
                case SessionStarted: {
                    listener.sessionStarted(event);
                    break;
                }
                case SessionEnded: {
                    listener.sessionEnded(event);
                    break;
                }
                case ProjectSkipped: {
                    listener.projectSkipped(event);
                    break;
                }
                case ProjectStarted: {
                    listener.projectStarted(event);
                    break;
                }
                case ProjectSucceeded: {
                    listener.projectSucceeded(event);
                    break;
                }
                case ProjectFailed: {
                    listener.projectFailed(event);
                    break;
                }
                case MojoSkipped: {
                    listener.mojoSkipped(event);
                    break;
                }
                case MojoStarted: {
                    listener.mojoStarted(event);
                    break;
                }
                case MojoSucceeded: {
                    listener.mojoSucceeded(event);
                    break;
                }
                case MojoFailed: {
                    listener.mojoFailed(event);
                    break;
                }
                case ForkStarted: {
                    listener.forkStarted(event);
                    break;
                }
                case ForkSucceeded: {
                    listener.forkSucceeded(event);
                    break;
                }
                case ForkFailed: {
                    listener.forkFailed(event);
                    break;
                }
                case ForkedProjectStarted: {
                    listener.forkedProjectStarted(event);
                    break;
                }
                case ForkedProjectSucceeded: {
                    listener.forkedProjectSucceeded(event);
                    break;
                }
                case ForkedProjectFailed: {
                    listener.forkedProjectFailed(event);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown execution event type " + (Object)((Object)eventType));
                }
            }
        }
    }
}

