/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Component(role=PluginManager.class)
public class DefaultPluginManager
implements PluginManager {
    @Requirement
    private PlexusContainer container;
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;
    @Requirement
    private LegacySupport legacySupport;

    @Override
    public void executeMojo(MavenProject project, MojoExecution execution, MavenSession session2) throws MojoExecutionException, ArtifactResolutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPluginComponent(Plugin plugin, String role, String roleHint) throws PluginManagerException, ComponentLookupException {
        PluginDescriptor pluginDescriptor;
        MavenSession session2 = this.legacySupport.getSession();
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, session2.getCurrentProject().getRemotePluginRepositories(), session2.getRepositorySession());
            this.pluginManager.setupPluginRealm(pluginDescriptor, session2, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginDescriptor.getClassRealm());
            Object object = this.container.lookup(role, roleHint);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getPluginComponents(Plugin plugin, String role) throws ComponentLookupException, PluginManagerException {
        PluginDescriptor pluginDescriptor;
        MavenSession session2 = this.legacySupport.getSession();
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, session2.getCurrentProject().getRemotePluginRepositories(), session2.getRepositorySession());
            this.pluginManager.setupPluginRealm(pluginDescriptor, session2, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginDescriptor.getClassRealm());
            Map<String, Object> map2 = this.container.lookupMap(role);
            return map2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public Plugin getPluginDefinitionForPrefix(String prefix, MavenSession session2, MavenProject project) {
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session2);
        request.setPom(project.getModel());
        try {
            PluginPrefixResult result2 = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result2.getGroupId());
            plugin.setArtifactId(result2.getArtifactId());
            return plugin;
        }
        catch (NoPluginFoundForPrefixException e) {
            return null;
        }
    }

    @Override
    public PluginDescriptor getPluginDescriptorForPrefix(String prefix) {
        MavenSession session2 = this.legacySupport.getSession();
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session2);
        try {
            PluginPrefixResult result2 = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result2.getGroupId());
            plugin.setArtifactId(result2.getArtifactId());
            return this.loadPluginDescriptor(plugin, session2.getCurrentProject(), session2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public PluginDescriptor loadPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session2) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        return this.verifyPlugin(plugin, project, session2.getSettings(), session2.getLocalRepository());
    }

    @Override
    public PluginDescriptor loadPluginFully(Plugin plugin, MavenProject project, MavenSession session2) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(plugin, project, session2);
        try {
            this.pluginManager.setupPluginRealm(pluginDescriptor, session2, null, null, null);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    @Override
    public PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings2, ArtifactRepository localRepository) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        MavenSession session2 = this.legacySupport.getSession();
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session2.getRepositorySession(), project.getRemotePluginRepositories());
            plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
        }
        try {
            return this.pluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), session2.getRepositorySession());
        }
        catch (PluginResolutionException e) {
            throw new PluginNotFoundException(plugin, project.getPluginArtifactRepositories());
        }
        catch (InvalidPluginDescriptorException | PluginDescriptorParsingException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
    }
}

