/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugin.version.internal.DefaultPluginVersionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

@Component(role=PluginVersionResolver.class)
public class DefaultPluginVersionResolver
implements PluginVersionResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;
    @Requirement
    private MavenPluginManager pluginManager;

    @Override
    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        PluginVersionResult result2 = this.resolveFromProject(request);
        if (result2 == null) {
            result2 = this.resolveFromRepository(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result2.getVersion() + " from repository " + result2.getRepository());
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result2.getVersion() + " from POM " + request.getPom());
        }
        return result2;
    }

    private PluginVersionResult resolveFromRepository(PluginVersionRequest request) throws PluginVersionResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, request);
        DefaultPluginVersionResult result2 = new DefaultPluginVersionResult();
        DefaultMetadata metadata2 = new DefaultMetadata(request.getGroupId(), request.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        requests.add(new MetadataRequest(metadata2, null, REPOSITORY_CONTEXT).setTrace(trace));
        for (RemoteRepository repository : request.getRepositories()) {
            requests.add(new MetadataRequest(metadata2, repository, REPOSITORY_CONTEXT).setTrace(trace));
        }
        List<MetadataResult> results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        Versions versions2 = new Versions();
        for (MetadataResult res2 : results) {
            ArtifactRepository repository = res2.getRequest().getRepository();
            if (repository == null) {
                repository = request.getRepositorySession().getLocalRepository();
            }
            this.mergeMetadata(request.getRepositorySession(), trace, versions2, res2.getMetadata(), repository);
        }
        this.selectVersion(result2, request, versions2);
        return result2;
    }

    private void selectVersion(DefaultPluginVersionResult result2, PluginVersionRequest request, Versions versions2) throws PluginVersionResolutionException {
        String version = null;
        ArtifactRepository repo = null;
        if (StringUtils.isNotEmpty(versions2.releaseVersion)) {
            version = versions2.releaseVersion;
            repo = versions2.releaseRepository;
        } else if (StringUtils.isNotEmpty(versions2.latestVersion)) {
            version = versions2.latestVersion;
            repo = versions2.latestRepository;
        }
        if (version != null && !this.isCompatible(request, version)) {
            versions2.versions.remove(version);
            version = null;
        }
        if (version == null) {
            String ver;
            GenericVersionScheme versionScheme = new GenericVersionScheme();
            TreeSet releases = new TreeSet(Collections.reverseOrder());
            TreeSet snapshots = new TreeSet(Collections.reverseOrder());
            for (String ver2 : versions2.versions.keySet()) {
                try {
                    Version v = versionScheme.parseVersion(ver2);
                    if (ver2.endsWith("-SNAPSHOT")) {
                        snapshots.add(v);
                        continue;
                    }
                    releases.add(v);
                }
                catch (InvalidVersionSpecificationException v) {}
            }
            for (Version v : releases) {
                ver = v.toString();
                if (!this.isCompatible(request, ver)) continue;
                version = ver;
                repo = versions2.versions.get(version);
                break;
            }
            if (version == null) {
                for (Version v : snapshots) {
                    ver = v.toString();
                    if (!this.isCompatible(request, ver)) continue;
                    version = ver;
                    repo = versions2.versions.get(version);
                    break;
                }
            }
        }
        if (version == null) {
            throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), request.getRepositorySession().getLocalRepository(), request.getRepositories(), "Plugin not found in any plugin repository");
        }
        result2.setVersion(version);
        result2.setRepository(repo);
    }

    private boolean isCompatible(PluginVersionRequest request, String version) {
        PluginDescriptor pluginDescriptor;
        Plugin plugin = new Plugin();
        plugin.setGroupId(request.getGroupId());
        plugin.setArtifactId(request.getArtifactId());
        plugin.setVersion(version);
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, request.getRepositories(), request.getRepositorySession());
        }
        catch (PluginResolutionException e) {
            this.logger.debug("Ignoring unresolvable plugin version " + version, e);
            return false;
        }
        catch (Exception e) {
            return true;
        }
        try {
            this.pluginManager.checkRequiredMavenVersion(pluginDescriptor);
        }
        catch (Exception e) {
            this.logger.debug("Ignoring incompatible plugin version " + version + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    private void mergeMetadata(RepositorySystemSession session2, RequestTrace trace, Versions versions2, Metadata metadata2, ArtifactRepository repository) {
        if (metadata2 != null && metadata2.getFile() != null && metadata2.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                org.apache.maven.artifact.repository.metadata.Metadata repoMetadata = this.metadataReader.read(metadata2.getFile(), options);
                this.mergeMetadata(versions2, repoMetadata, repository);
            }
            catch (IOException e) {
                this.invalidMetadata(session2, trace, metadata2, repository, e);
            }
        }
    }

    private void invalidMetadata(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session2.getRepositoryListener();
        if (listener != null) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INVALID);
            event.setTrace(trace);
            event.setMetadata(metadata2);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event.build());
        }
    }

    private void mergeMetadata(Versions versions2, org.apache.maven.artifact.repository.metadata.Metadata source, ArtifactRepository repository) {
        Versioning versioning = source.getVersioning();
        if (versioning != null) {
            String timestamp = StringUtils.clean(versioning.getLastUpdated());
            if (StringUtils.isNotEmpty(versioning.getRelease()) && timestamp.compareTo(versions2.releaseTimestamp) > 0) {
                versions2.releaseVersion = versioning.getRelease();
                versions2.releaseTimestamp = timestamp;
                versions2.releaseRepository = repository;
            }
            if (StringUtils.isNotEmpty(versioning.getLatest()) && timestamp.compareTo(versions2.latestTimestamp) > 0) {
                versions2.latestVersion = versioning.getLatest();
                versions2.latestTimestamp = timestamp;
                versions2.latestRepository = repository;
            }
            for (String version : versioning.getVersions()) {
                if (versions2.versions.containsKey(version)) continue;
                versions2.versions.put(version, repository);
            }
        }
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request) {
        Build build2;
        PluginVersionResult result2 = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result2 = this.resolveFromProject(request, (build2 = request.getPom().getBuild()).getPlugins())) == null && build2.getPluginManagement() != null) {
            result2 = this.resolveFromProject(request, build2.getPluginManagement().getPlugins());
        }
        return result2;
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!request.getGroupId().equals(plugin.getGroupId()) || !request.getArtifactId().equals(plugin.getArtifactId())) continue;
            if (plugin.getVersion() != null) {
                return new DefaultPluginVersionResult(plugin.getVersion());
            }
            return null;
        }
        return null;
    }

    static class Versions {
        String releaseVersion = "";
        String releaseTimestamp = "";
        ArtifactRepository releaseRepository;
        String latestVersion = "";
        String latestTimestamp = "";
        ArtifactRepository latestRepository;
        Map<String, ArtifactRepository> versions = new LinkedHashMap<String, ArtifactRepository>();

        Versions() {
        }
    }
}

