/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.project.ProjectBuildingResult;

public class ProjectBuildingException
extends Exception {
    private final String projectId;
    private File pomFile;
    private List<ProjectBuildingResult> results;

    public ProjectBuildingException(String projectId, String message2, Throwable cause) {
        super(ProjectBuildingException.createMessage(message2, projectId, null), cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message2, File pomFile) {
        super(ProjectBuildingException.createMessage(message2, projectId, pomFile));
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    protected ProjectBuildingException(String projectId, String message2, File pomFile, Throwable cause) {
        super(ProjectBuildingException.createMessage(message2, projectId, pomFile), cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(List<ProjectBuildingResult> results) {
        super(ProjectBuildingException.createMessage(results));
        this.projectId = "";
        this.results = results;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String getPomLocation() {
        if (this.getPomFile() != null) {
            return this.getPomFile().getAbsolutePath();
        }
        return "null";
    }

    public String getProjectId() {
        return this.projectId;
    }

    public List<ProjectBuildingResult> getResults() {
        return this.results;
    }

    private static String createMessage(String message2, String projectId, File pomFile) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(message2);
        buffer.append(" for project ").append(projectId);
        if (pomFile != null) {
            buffer.append(" at ").append(pomFile.getAbsolutePath());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createMessage(List<ProjectBuildingResult> results) {
        StringWriter buffer = new StringWriter(1024);
        writer.println("Some problems were encountered while processing the POMs:");
        try (PrintWriter writer = new PrintWriter(buffer);){
            for (ProjectBuildingResult result2 : results) {
                for (ModelProblem problem : result2.getProblems()) {
                    writer.print("[");
                    writer.print((Object)problem.getSeverity());
                    writer.print("] ");
                    writer.print(problem.getMessage());
                    writer.print(" @ ");
                    writer.println(ModelProblemUtils.formatLocation(problem, result2.getProjectId()));
                }
            }
        }
        return buffer.toString();
    }
}

