/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ToolchainManager.class)
public class DefaultToolchainManager
implements ToolchainManager {
    @Requirement
    Logger logger;
    @Requirement(role=ToolchainFactory.class)
    Map<String, ToolchainFactory> factories;

    @Override
    public Toolchain getToolchainFromBuildContext(String type2, MavenSession session2) {
        List<Toolchain> toolchains;
        Map<String, Object> context2 = this.retrieveContext(session2);
        ToolchainModel model = (ToolchainModel)context2.get(DefaultToolchainManager.getStorageKey(type2));
        if (model != null && !(toolchains = this.selectToolchains(Collections.singletonList(model), type2, null)).isEmpty()) {
            return toolchains.get(0);
        }
        return null;
    }

    @Override
    public List<Toolchain> getToolchains(MavenSession session2, String type2, Map<String, String> requirements) {
        List<ToolchainModel> models = session2.getRequest().getToolchains().get(type2);
        return this.selectToolchains(models, type2, requirements);
    }

    private List<Toolchain> selectToolchains(List<ToolchainModel> models, String type2, Map<String, String> requirements) {
        ArrayList<Toolchain> toolchains = new ArrayList<Toolchain>();
        if (models != null) {
            ToolchainFactory fact = this.factories.get(type2);
            if (fact == null) {
                this.logger.error("Missing toolchain factory for type: " + type2 + ". Possibly caused by misconfigured project.");
            } else {
                for (ToolchainModel model : models) {
                    try {
                        ToolchainPrivate toolchain = fact.createToolchain(model);
                        if (requirements != null && !toolchain.matchesRequirements(requirements)) continue;
                        toolchains.add(toolchain);
                    }
                    catch (MisconfiguredToolchainException ex) {
                        this.logger.error("Misconfigured toolchain.", ex);
                    }
                }
            }
        }
        return toolchains;
    }

    Map<String, Object> retrieveContext(MavenSession session2) {
        Map<Object, Object> context2 = null;
        if (session2 != null) {
            PluginDescriptor desc = new PluginDescriptor();
            desc.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
            desc.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId("toolchains"));
            MavenProject current2 = session2.getCurrentProject();
            if (current2 != null) {
                context2 = session2.getPluginContext(desc, current2);
            }
        }
        return context2 != null ? context2 : new HashMap();
    }

    public static final String getStorageKey(String type2) {
        return "toolchain-" + type2;
    }
}

