/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transport.http.AuthSchemePool;
import org.eclipse.aether.transport.http.SslConfig;
import org.eclipse.aether.transport.http.SslSocketFactory;
import org.eclipse.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GlobalState
implements Closeable {
    private static final String KEY = GlobalState.class.getName();
    private static final String CONFIG_PROP_CACHE_STATE = "aether.connector.http.cacheState";
    private final ConcurrentMap<SslConfig, ClientConnectionManager> connectionManagers = new ConcurrentHashMap<SslConfig, ClientConnectionManager>();
    private final ConcurrentMap<CompoundKey, Object> userTokens = new ConcurrentHashMap<CompoundKey, Object>();
    private final ConcurrentMap<HttpHost, AuthSchemePool> authSchemePools = new ConcurrentHashMap<HttpHost, AuthSchemePool>();
    private final ConcurrentMap<CompoundKey, Boolean> expectContinues = new ConcurrentHashMap<CompoundKey, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalState get(RepositorySystemSession session2) {
        RepositoryCache repoCache = session2.getCache();
        if (repoCache == null) return null;
        if (!ConfigUtils.getBoolean(session2, true, CONFIG_PROP_CACHE_STATE)) {
            return null;
        }
        Object tmp = repoCache.get(session2, KEY);
        if (tmp instanceof GlobalState) {
            return (GlobalState)tmp;
        }
        Class<GlobalState> clazz = GlobalState.class;
        synchronized (GlobalState.class) {
            tmp = repoCache.get(session2, KEY);
            if (tmp instanceof GlobalState) {
                return (GlobalState)tmp;
            }
            GlobalState cache2 = new GlobalState();
            repoCache.put(session2, KEY, cache2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache2;
        }
    }

    private GlobalState() {
    }

    @Override
    public void close() {
        Iterator it = this.connectionManagers.entrySet().iterator();
        while (it.hasNext()) {
            ClientConnectionManager connMgr = (ClientConnectionManager)it.next().getValue();
            it.remove();
            connMgr.shutdown();
        }
    }

    public ClientConnectionManager getConnectionManager(SslConfig config) {
        ClientConnectionManager manager = (ClientConnectionManager)this.connectionManagers.get(config);
        if (manager == null) {
            ClientConnectionManager connMgr = GlobalState.newConnectionManager(config);
            manager = this.connectionManagers.putIfAbsent(config, connMgr);
            if (manager != null) {
                connMgr.shutdown();
            } else {
                manager = connMgr;
            }
        }
        return manager;
    }

    public static ClientConnectionManager newConnectionManager(SslConfig sslConfig) {
        SchemeRegistry schemeReg = new SchemeRegistry();
        schemeReg.register(new Scheme("http", 80, new PlainSocketFactory()));
        schemeReg.register(new Scheme("https", 443, new SslSocketFactory(sslConfig)));
        PoolingClientConnectionManager connMgr = new PoolingClientConnectionManager(schemeReg);
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(50);
        return connMgr;
    }

    public Object getUserToken(CompoundKey key) {
        return this.userTokens.get(key);
    }

    public void setUserToken(CompoundKey key, Object userToken) {
        if (userToken != null) {
            this.userTokens.put(key, userToken);
        } else {
            this.userTokens.remove(key);
        }
    }

    public ConcurrentMap<HttpHost, AuthSchemePool> getAuthSchemePools() {
        return this.authSchemePools;
    }

    public Boolean getExpectContinue(CompoundKey key) {
        return (Boolean)this.expectContinues.get(key);
    }

    public void setExpectContinue(CompoundKey key, boolean enabled2) {
        this.expectContinues.put(key, enabled2);
    }

    static class CompoundKey {
        private final Object[] keys;

        public CompoundKey(Object ... keys2) {
            this.keys = keys2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            CompoundKey that = (CompoundKey)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + Arrays.hashCode(this.keys);
            return hash;
        }

        public String toString() {
            return Arrays.toString(this.keys);
        }
    }
}

