/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictMarker
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context2) throws RepositoryException {
        Map stats = (Map)context2.get(TransformationContextKeys.STATS);
        long time1 = System.currentTimeMillis();
        IdentityHashMap<DependencyNode, Object> nodes = new IdentityHashMap<DependencyNode, Object>(1024);
        HashMap<Object, ConflictGroup> groups2 = new HashMap<Object, ConflictGroup>(1024);
        this.analyze(node, nodes, groups2, new int[]{0});
        long time2 = System.currentTimeMillis();
        Map<DependencyNode, Object> conflictIds = this.mark(nodes.keySet(), groups2);
        context2.put(TransformationContextKeys.CONFLICT_IDS, conflictIds);
        if (stats != null) {
            long time3 = System.currentTimeMillis();
            stats.put("ConflictMarker.analyzeTime", time2 - time1);
            stats.put("ConflictMarker.markTime", time3 - time2);
            stats.put("ConflictMarker.nodeCount", nodes.size());
        }
        return node;
    }

    private void analyze(DependencyNode node, Map<DependencyNode, Object> nodes, Map<Object, ConflictGroup> groups2, int[] counter) {
        if (nodes.put(node, Boolean.TRUE) != null) {
            return;
        }
        Set<Object> keys2 = this.getKeys(node);
        if (!keys2.isEmpty()) {
            ConflictGroup group = null;
            boolean fixMappings = false;
            for (Object key : keys2) {
                Set<Object> newKeys;
                ConflictGroup g = groups2.get(key);
                if (group == g) continue;
                if (group == null) {
                    newKeys = this.merge(g.keys, keys2);
                    if (newKeys == g.keys) {
                        group = g;
                        break;
                    }
                    int n = counter[0];
                    counter[0] = n + 1;
                    group = new ConflictGroup(newKeys, n);
                    fixMappings = true;
                    continue;
                }
                if (g == null) {
                    fixMappings = true;
                    continue;
                }
                newKeys = this.merge(g.keys, group.keys);
                if (newKeys == g.keys) {
                    group = g;
                    fixMappings = false;
                    break;
                }
                if (newKeys == group.keys) continue;
                int n = counter[0];
                counter[0] = n + 1;
                group = new ConflictGroup(newKeys, n);
                fixMappings = true;
            }
            if (group == null) {
                int n = counter[0];
                counter[0] = n + 1;
                group = new ConflictGroup(keys2, n);
                fixMappings = true;
            }
            if (fixMappings) {
                for (Object key : group.keys) {
                    groups2.put(key, group);
                }
            }
        }
        for (DependencyNode child : node.getChildren()) {
            this.analyze(child, nodes, groups2, counter);
        }
    }

    private Set<Object> merge(Set<Object> keys1, Set<Object> keys2) {
        int size2;
        int size1 = keys1.size();
        if (size1 < (size2 = keys2.size())) {
            if (keys2.containsAll(keys1)) {
                return keys2;
            }
        } else if (keys1.containsAll(keys2)) {
            return keys1;
        }
        HashSet<Object> keys3 = new HashSet<Object>();
        keys3.addAll(keys1);
        keys3.addAll(keys2);
        return keys3;
    }

    private Set<Object> getKeys(DependencyNode node) {
        Set<Object> keys2;
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            Set keys22 = Collections.emptySet();
        } else {
            Object key = ConflictMarker.toKey(dependency.getArtifact());
            if (node.getRelocations().isEmpty() && node.getAliases().isEmpty()) {
                keys2 = Collections.singleton(key);
            } else {
                keys2 = new HashSet<Object>();
                keys2.add(key);
                for (Artifact artifact : node.getRelocations()) {
                    key = ConflictMarker.toKey(artifact);
                    keys2.add(key);
                }
                for (Artifact artifact : node.getAliases()) {
                    key = ConflictMarker.toKey(artifact);
                    keys2.add(key);
                }
            }
        }
        return keys2;
    }

    private Map<DependencyNode, Object> mark(Collection<DependencyNode> nodes, Map<Object, ConflictGroup> groups2) {
        IdentityHashMap<DependencyNode, Object> conflictIds = new IdentityHashMap<DependencyNode, Object>(nodes.size() + 1);
        for (DependencyNode node : nodes) {
            Dependency dependency = node.getDependency();
            if (dependency == null) continue;
            Object key = ConflictMarker.toKey(dependency.getArtifact());
            conflictIds.put(node, groups2.get((Object)key).index);
        }
        return conflictIds;
    }

    private static Object toKey(Artifact artifact) {
        return new Key(artifact);
    }

    static class Key {
        private final Artifact artifact;

        public Key(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.artifact.getArtifactId().hashCode();
            hash = hash * 31 + this.artifact.getGroupId().hashCode();
            hash = hash * 31 + this.artifact.getClassifier().hashCode();
            hash = hash * 31 + this.artifact.getExtension().hashCode();
            return hash;
        }

        public String toString() {
            return this.artifact.getGroupId() + ':' + this.artifact.getArtifactId() + ':' + this.artifact.getClassifier() + ':' + this.artifact.getExtension();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGroup {
        final Set<Object> keys;
        final int index;

        public ConflictGroup(Set<Object> keys2, int index2) {
            this.keys = keys2;
            this.index = index2;
        }

        public String toString() {
            return String.valueOf(this.keys);
        }
    }
}

