/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u0012*\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0014\u0010#\u001a\u00020\u0012*\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "removedFunctions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lkotlin/collections/HashMap;", "createDefaultImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "forCompatibility", "", "createJvmDefaultCompatibilityDelegate", "", "handleAnnotationClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "handleInterface", "lower", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "bridgeToStatic", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "bridgeViaAccessorTo", "backend.jvm"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashMap<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> removedFunctions;

    public InterfaceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        boolean bl = false;
        this.removedFunctions = new HashMap();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        if (!IrCodegenUtilsKt.isJvmInterface(irClass2)) {
            return;
        }
        ClassKind classKind = irClass2.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[classKind.ordinal()];
        switch (n) {
            case 1: {
                this.handleInterface(irClass2);
                break;
            }
            case 2: {
                this.handleAnnotationClass(irClass2);
                break;
            }
            default: {
                return;
            }
        }
        CollectionsKt.removeAll(irClass2.getDeclarations(), (Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ InterfaceLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (!(it instanceof IrFunction)) return false;
                Map map2 = InterfaceLowering.access$getRemovedFunctions$p(this.this$0);
                IrFunctionSymbol irFunctionSymbol = ((IrFunction)it).getSymbol();
                boolean bl = false;
                Map map3 = map2;
                if (map3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (!map3.containsKey(irFunctionSymbol)) return false;
                return true;
            }
        });
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations$backend_jvm().getDefaultImplsClass(irClass2);
        Collection collection = defaultImplsIrClass.getDeclarations();
        boolean bl = false;
        if (!collection.isEmpty()) {
            irClass2.getDeclarations().add(defaultImplsIrClass);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass2, this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IrClass irClass2) {
        void $this$filterIsInstanceTo$iv$iv;
        Object superImpl;
        JvmDefaultMode jvmDefaultMode = this.context.getState().getJvmDefaultMode();
        boolean isCompatibilityMode = jvmDefaultMode.isCompatibility() && !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefaultNoCompatibilityAnnotation(irClass2);
        Iterator<IrSimpleFunction> iterator2 = IrUtilsKt.getFunctions(irClass2).iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction defaultImpl;
            boolean bl;
            Object object;
            Object defaultImpl2;
            IrSimpleFunction function2 = iterator2.next();
            if (function2.getModality() == Modality.ABSTRACT) continue;
            if (function2.isFakeOverride()) {
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "function.name.asString()");
                if (StringsKt.endsWith$default(string2, "$default", false, 2, null)) continue;
                IrSimpleFunction irSimpleFunction = IrFakeOverrideUtilsKt.resolveFakeOverride$default(function2, false, null, 3, null);
                if (irSimpleFunction == null) {
                    String string3 = Intrinsics.stringPlus("No single implementation found for: ", RenderIrElementKt.render(function2));
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                IrSimpleFunction implementation2 = irSimpleFunction;
                if (DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(implementation2)) continue;
                if (!InheritedDefaultMethodsOnClassesLoweringKt.isDefinitelyNotDefaultImplsMethod(function2, jvmDefaultMode, implementation2)) {
                    defaultImpl2 = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                    superImpl = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.firstSuperMethodFromKotlin(function2, implementation2);
                    object = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations$backend_jvm(), (IrSimpleFunction)superImpl.getOwner(), false, 2, null);
                    bl = false;
                    boolean bl3 = false;
                    Object it = object;
                    boolean bl4 = false;
                    this.bridgeToStatic((IrFunction)defaultImpl2, (IrSimpleFunction)it);
                    continue;
                }
                if (!isCompatibilityMode || !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode)) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (DescriptorVisibilities.isPrivate(function2.getVisibility()) && !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode) || Intrinsics.areEqual(function2.getOrigin(), IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) && !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode) || Intrinsics.areEqual(function2.getOrigin(), JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_ANNOTATIONS.INSTANCE)) {
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                defaultImpl2 = this.removedFunctions;
                superImpl = (IrSimpleFunctionSymbol)function2.getSymbol();
                object = (IrSimpleFunctionSymbol)defaultImpl.getSymbol();
                bl = false;
                defaultImpl2.put(superImpl, object);
                continue;
            }
            if (!org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode)) {
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
                function2.setBody(null);
                continue;
            }
            if (!isCompatibilityMode) continue;
            this.createJvmDefaultCompatibilityDelegate(function2);
        }
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations$backend_jvm().getDefaultImplsClass(irClass2);
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        superImpl = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrField field : (List)destination$iv$iv) {
            if (!Intrinsics.areEqual(field.getOrigin(), JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE) && !Intrinsics.areEqual(field.getOrigin(), JvmLoweredDeclarationOrigin.GENERATED_ASSERTION_ENABLED_FIELD.INSTANCE)) continue;
            irClass2.getDeclarations().remove(field);
            defaultImplsIrClass.getDeclarations().add(0, field);
            field.setParent(defaultImplsIrClass);
            IrExpressionBody irExpressionBody = field.getInitializer();
            if (irExpressionBody == null) continue;
            IrExpressionBody cfr_ignored_0 = (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody, defaultImplsIrClass);
        }
    }

    private final void createJvmDefaultCompatibilityDelegate(IrSimpleFunction function2) {
        IrSimpleFunction defaultImpl = this.createDefaultImpl(function2, true);
        this.bridgeViaAccessorTo(defaultImpl, function2);
    }

    private final void handleAnnotationClass(IrClass irClass2) {
        Sequence<IrSimpleFunction> annotationsMethods2 = SequencesKt.filter(IrUtilsKt.getFunctions(irClass2), handleAnnotationClass.annotationsMethods.1.INSTANCE);
        if (SequencesKt.none(annotationsMethods2)) {
            return;
        }
        Iterator<IrSimpleFunction> iterator2 = annotationsMethods2.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction function2 = iterator2.next();
            IrSimpleFunction defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
            defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo(function2, defaultImpl));
            Map map2 = this.removedFunctions;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)function2.getSymbol();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = (IrSimpleFunctionSymbol)defaultImpl.getSymbol();
            boolean bl = false;
            map2.put(irSimpleFunctionSymbol, irSimpleFunctionSymbol2);
        }
    }

    private final IrSimpleFunction createDefaultImpl(IrSimpleFunction function2, boolean forCompatibility) {
        IrSimpleFunction irSimpleFunction = this.context.getCachedDeclarations$backend_jvm().getDefaultImplsFunction(function2, forCompatibility);
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleFunction newFunction2 = irSimpleFunction;
        boolean bl3 = false;
        IrUtilsKt.getParentAsClass(newFunction2).getDeclarations().add(newFunction2);
        return irSimpleFunction;
    }

    static /* synthetic */ IrSimpleFunction createDefaultImpl$default(InterfaceLowering interfaceLowering, IrSimpleFunction irSimpleFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return interfaceLowering.createDefaultImpl(irSimpleFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeToStatic(IrFunction $this$bridgeToStatic, IrSimpleFunction callTarget) {
        void call2;
        int i;
        boolean bl;
        int n;
        IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), $this$bridgeToStatic.getReturnType(), (IrSimpleFunctionSymbol)callTarget.getSymbol(), 0, 0, null, null, 240, null);
        boolean bl2 = false;
        boolean bl3 = false;
        IrCallImpl irCallImpl2 = irCallImpl;
        IrFunction irFunction2 = $this$bridgeToStatic;
        boolean bl4 = false;
        Iterable $this$forEachIndexed$iv = callTarget.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            n = index$iv++;
            bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv;
            i = n;
            boolean bl5 = false;
            call2.putTypeArgument(i, org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createPlaceholderAnyNType(this.getContext().getIrBuiltIns()));
        }
        $this$forEachIndexed$iv = $this$bridgeToStatic.getValueParameters();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            n = index$iv++;
            bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter $noName_1 = (IrValueParameter)item$iv;
            i = n;
            boolean bl6 = false;
            call2.putValueArgument(i, new IrGetValueImpl($this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), it.getSymbol(), null, 8, null));
        }
        Unit unit = Unit.INSTANCE;
        IrExpression irExpression = irCallImpl;
        irFunction2.setBody(new IrExpressionBodyImpl(irExpression));
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeViaAccessorTo(IrFunction $this$bridgeViaAccessorTo, IrSimpleFunction callTarget) {
        void call2;
        IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getReturnType(), (IrSimpleFunctionSymbol)callTarget.getSymbol(), 0, 0, null, (IrClassSymbol)IrUtilsKt.getParentAsClass(callTarget).getSymbol(), 112, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl irCallImpl2 = irCallImpl;
        IrFunction irFunction2 = $this$bridgeViaAccessorTo;
        boolean bl3 = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.drop((Iterable)$this$bridgeViaAccessorTo.getTypeParameters(), IrUtilsKt.getParentAsClass(callTarget).getTypeParameters().size());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameter;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv;
            int i = n;
            boolean bl5 = false;
            call2.putTypeArgument(i, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
        }
        int offset2 = 0;
        IrValueParameter irValueParameter = callTarget.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter irValueParameter2 = irValueParameter;
            boolean bl6 = false;
            boolean bl7 = false;
            IrValueParameter it = irValueParameter2;
            boolean bl8 = false;
            call2.setDispatchReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        irValueParameter = callTarget.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter irValueParameter3 = irValueParameter;
            boolean bl9 = false;
            boolean bl10 = false;
            IrValueParameter it = irValueParameter3;
            boolean bl11 = false;
            call2.setExtensionReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        int n = offset2;
        int n2 = $this$bridgeViaAccessorTo.getValueParameters().size();
        if (n < n2) {
            do {
                int i = n++;
                call2.putValueArgument(i - offset2, new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(i).getSymbol(), null, 8, null));
            } while (n < n2);
        }
        Unit unit = Unit.INSTANCE;
        IrExpression irExpression = irCallImpl;
        irFunction2.setBody(new IrExpressionBodyImpl(irExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Map map2 = this.removedFunctions;
        Object object = expression2.getReturnTargetSymbol();
        boolean bl = false;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map2.get(object);
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol == null ? null : (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        InterfaceLowering interfaceLowering = this;
        if (newFunction2 != null) {
            void $this$visitReturn_u24lambda_u2d9;
            boolean bl2 = false;
            boolean bl3 = false;
            object = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl4 = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$visitReturn_u24lambda_u2d9.getStartOffset(), $this$visitReturn_u24lambda_u2d9.getEndOffset(), $this$visitReturn_u24lambda_u2d9.getType(), newFunction2.getSymbol(), $this$visitReturn_u24lambda_u2d9.getValue());
            interfaceLowering = interfaceLowering2;
            irReturn = irReturnImpl;
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol == null ? null : (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        return super.visitCall(newFunction2 != null ? org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, newFunction2, this.context.getIrBuiltIns()) : expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Map map2 = this.removedFunctions;
        Object object = (IrFunctionSymbol)expression2.getSymbol();
        boolean bl = false;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map2.get(object);
        IrSimpleFunction newFunction2 = irSimpleFunctionSymbol == null ? null : (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        InterfaceLowering interfaceLowering = this;
        if (newFunction2 != null) {
            void $this$visitFunctionReference_u24lambda_u2d11;
            boolean bl2 = false;
            boolean bl3 = false;
            object = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl4 = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u2d11.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d11.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d11.getType(), newFunction2.getSymbol(), newFunction2.getTypeParameters().size(), newFunction2.getValueParameters().size(), expression2.getReflectionTarget(), $this$visitFunctionReference_u24lambda_u2d11.getOrigin());
            boolean bl5 = false;
            boolean bl6 = false;
            IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2d11_u24lambda_u2d10 = irFunctionReferenceImpl;
            boolean bl7 = false;
            org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.copyFromWithPlaceholderTypeArguments($this$visitFunctionReference_u24lambda_u2d11_u24lambda_u2d10, expression2, this.getContext().getIrBuiltIns());
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$visitFunctionReference_u24lambda_u2d11_u24lambda_u2d10, expression2);
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl;
            interfaceLowering = interfaceLowering2;
            irFunctionReference = irFunctionReferenceImpl2;
        } else {
            irFunctionReference = expression2;
        }
        return super.visitFunctionReference(irFunctionReference);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ HashMap access$getRemovedFunctions$p(InterfaceLowering $this) {
        return $this.removedFunctions;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.INTERFACE.ordinal()] = 1;
            nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

