/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u001a!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u001a\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a1\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a\u001f\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a\u0011\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\b\u001a\r\u0010\u0011\u001a\u00020\u0002*\u00020\u0004H\u0086\b\u001a\r\u0010\u0012\u001a\u00020\u0002*\u00020\u0004H\u0086\b\u001a3\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"beginMeasureWallAndThreadTimes", "", "", "threadMXBean", "Ljava/lang/management/ThreadMXBean;", "beginMeasureWallAndThreadTimesAndMemory", "withGC", "", "beginMeasureWallTime", "endMeasureWallAndThreadTimes", "", "perfCounters", "Lorg/jetbrains/kotlin/daemon/common/PerfCounters;", "startState", "endMeasureWallAndThreadTimesAndMemory", "endMeasureWallTime", "usedMemory", "threadCpuTime", "threadUserTime", "withMeasure", "R", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "obj", "", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/daemon/common/Profiler;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "daemon-common"})
public final class PerfUtilsKt {
    public static final <R> R withMeasure(@NotNull Profiler $this$withMeasure, @Nullable Object obj, @NotNull Function0<? extends R> body2) {
        Intrinsics.checkNotNullParameter($this$withMeasure, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$withMeasure = false;
        List<Long> startState = $this$withMeasure.beginMeasure(obj);
        R res2 = body2.invoke();
        $this$withMeasure.endMeasure(obj, startState);
        return res2;
    }

    public static final long threadCpuTime(@NotNull ThreadMXBean $this$threadCpuTime) {
        Intrinsics.checkNotNullParameter($this$threadCpuTime, "<this>");
        boolean $i$f$threadCpuTime = false;
        return $this$threadCpuTime.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime.getCurrentThreadCpuTime() : 0L;
    }

    public static final long threadUserTime(@NotNull ThreadMXBean $this$threadUserTime) {
        Intrinsics.checkNotNullParameter($this$threadUserTime, "<this>");
        boolean $i$f$threadUserTime = false;
        return $this$threadUserTime.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime.getCurrentThreadUserTime() : 0L;
    }

    public static final long usedMemory(boolean withGC) {
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    @NotNull
    public static final List<Long> beginMeasureWallTime() {
        boolean $i$f$beginMeasureWallTime = false;
        return CollectionsKt.listOf(System.nanoTime());
    }

    public static final void endMeasureWallTime(@NotNull PerfCounters perfCounters, @NotNull List<Long> startState) {
        List<Long> list2;
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallTime = false;
        List<Long> list3 = list2 = startState;
        boolean bl = false;
        long startTime = ((Number)list3.get(0)).longValue();
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters, System.nanoTime() - startTime, 0L, 0L, 0L, 14, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimes(@NotNull ThreadMXBean threadMXBean) {
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimes = false;
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static final void endMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        List<Long> list2;
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimes = false;
        List<Long> list3 = list2 = startState;
        boolean bl = false;
        long startTime = ((Number)list3.get(0)).longValue();
        List<Long> list4 = list2;
        boolean bl2 = false;
        long startThreadTime = ((Number)list4.get(1)).longValue();
        List<Long> list5 = list2;
        boolean bl3 = false;
        long startThreadUserTime = ((Number)list5.get(2)).longValue();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters, System.nanoTime() - startTime, ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime, ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime, 0L, 8, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimesAndMemory(boolean withGC, @NotNull ThreadMXBean threadMXBean) {
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startMem, startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static /* synthetic */ List beginMeasureWallAndThreadTimesAndMemory$default(boolean withGC, ThreadMXBean threadMXBean, int n, Object object) {
        if ((n & 1) != 0) {
            withGC = false;
        }
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startMem, startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static final void endMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        List<Long> list2;
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        List<Long> list3 = list2 = startState;
        boolean bl = false;
        long startMem = ((Number)list3.get(0)).longValue();
        List<Long> list4 = list2;
        boolean bl2 = false;
        long startTime = ((Number)list4.get(1)).longValue();
        List<Long> list5 = list2;
        boolean bl3 = false;
        long startThreadTime = ((Number)list5.get(2)).longValue();
        List<Long> list6 = list2;
        boolean bl4 = false;
        long startThreadUserTime = ((Number)list6.get(3)).longValue();
        long l = System.nanoTime() - startTime;
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long l2 = ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long l3 = ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        perfCounters.addMeasurement(l, l2, l3, rt$iv.totalMemory() - rt$iv.freeMemory() - startMem);
    }

    public static /* synthetic */ void endMeasureWallAndThreadTimesAndMemory$default(PerfCounters perfCounters, boolean withGC, ThreadMXBean threadMXBean, List startState, int n, Object object) {
        if ((n & 2) != 0) {
            withGC = false;
        }
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        Object object2 = object = startState;
        boolean bl = false;
        long startMem = ((Number)object2.get(0)).longValue();
        Object object3 = object;
        boolean bl2 = false;
        long startTime = ((Number)object3.get(1)).longValue();
        Object object4 = object;
        boolean bl3 = false;
        long startThreadTime = ((Number)object4.get(2)).longValue();
        Object object5 = object;
        boolean bl4 = false;
        long startThreadUserTime = ((Number)object5.get(3)).longValue();
        long l = System.nanoTime() - startTime;
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long l2 = ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long l3 = ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        perfCounters.addMeasurement(l, l2, l3, rt$iv.totalMemory() - rt$iv.freeMemory() - startMem);
    }
}

