/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_MULTIFILE_CLASS", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_MULTIFILE_CLASS", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_MULTIFILE_CLASS_SHORT", "", "getJVM_MULTIFILE_CLASS_SHORT", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "JVM_NAME_SHORT", "getJVM_NAME_SHORT", "JVM_PACKAGE_NAME", "getJVM_PACKAGE_NAME", "JVM_PACKAGE_NAME_SHORT", "MULTIFILE_PART_NAME_DELIMITER", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getFacadeClassInternalName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInternalName", "getLiteralStringFromAnnotation", "annotation", "getPartFqNameForDeserialized", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;
    @NotNull
    private static final FqName JVM_MULTIFILE_CLASS;
    @NotNull
    private static final String JVM_MULTIFILE_CLASS_SHORT;
    @NotNull
    private static final FqName JVM_PACKAGE_NAME;
    @NotNull
    private static final String JVM_PACKAGE_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getJVM_MULTIFILE_CLASS() {
        return JVM_MULTIFILE_CLASS;
    }

    @NotNull
    public final String getJVM_MULTIFILE_CLASS_SHORT() {
        return JVM_MULTIFILE_CLASS_SHORT;
    }

    @NotNull
    public final FqName getJVM_PACKAGE_NAME() {
        return JVM_PACKAGE_NAME;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor2);
        FqName fqName3 = fqName2 = object == null ? null : ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars();
        if (fqName2 == null) {
            object = Intrinsics.stringPlus("No implClassName for ", descriptor2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return fqName2;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName());
    }

    private final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter(file2, "file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        Object object2 = object == null ? null : ((ParsedJvmFileClassAnnotations)object).getJvmPackageName();
        FqName packageFqName = object2 == null ? file2.getPackageFqName() : object2;
        if (parsedAnnotations != null) {
            Object object3;
            Object object4;
            object = parsedAnnotations.getJvmName();
            if (object == null) {
                object4 = file2.getName();
                Intrinsics.checkNotNullExpressionValue(object4, "file.name");
                object3 = PackagePartClassUtils.getFilePartShortName((String)object4);
            } else {
                object3 = object;
            }
            Object simpleName2 = object3;
            object4 = packageFqName.child(Name.identifier((String)simpleName2));
            Intrinsics.checkNotNullExpressionValue(object4, "packageFqName.child(Name.identifier(simpleName))");
            Object facadeClassFqName = object4;
            if (parsedAnnotations.isMultifileClass()) {
                String string2 = file2.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "file.name");
                object4 = packageFqName.child(Name.identifier(INSTANCE.manglePartName((String)simpleName2, string2)));
                Intrinsics.checkNotNullExpressionValue(object4, "packageFqName.child(Name.identifier(manglePartName(simpleName, file.name)))");
                jvmFileClassInfo = new JvmMultifileClassPartInfo((FqName)object4, (FqName)facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo((FqName)facadeClassFqName, true);
            }
        } else {
            object2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue(object2, "file.name");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName(packageFqName, (String)object2), false);
        }
        return jvmFileClassInfo;
    }

    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file2) {
        FqName fqName2;
        Object object;
        Object object2;
        KtAnnotationEntry jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, JVM_NAME_SHORT);
        KtAnnotationEntry ktAnnotationEntry = jvmNameAnnotation;
        if (ktAnnotationEntry == null) {
            object2 = null;
        } else {
            object = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            Object p0 = object;
            boolean bl3 = false;
            String string2 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
            if (string2 == null) {
                object2 = null;
            } else {
                object = string2;
                bl = false;
                bl2 = false;
                p0 = object;
                boolean bl4 = false;
                object2 = Name.isValidIdentifier((String)p0) ? object : null;
            }
        }
        Object jvmName = object2;
        KtAnnotationEntry jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, JVM_PACKAGE_NAME_SHORT);
        object = jvmPackageNameAnnotation;
        if (object == null) {
            fqName2 = null;
        } else {
            Object object3 = object;
            boolean bl = false;
            boolean bl5 = false;
            Object p0 = object3;
            boolean bl6 = false;
            String string3 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
            if (string3 == null) {
                fqName2 = null;
            } else {
                object3 = string3;
                bl = false;
                bl5 = false;
                p0 = object3;
                boolean bl7 = false;
                fqName2 = new FqName((String)p0);
            }
        }
        FqName jvmPackageName = fqName2;
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        boolean isMultifileClass = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, JVM_MULTIFILE_CLASS_SHORT) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(shortName, "shortName");
        KtFileAnnotationList ktFileAnnotationList = file2.getFileAnnotationList();
        if (ktFileAnnotationList == null) {
            ktAnnotationEntry = null;
        } else {
            List<KtAnnotationEntry> list2 = ktFileAnnotationList.getAnnotationEntries();
            if (list2 == null) {
                ktAnnotationEntry = null;
            } else {
                Object v1;
                block5: {
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtSimpleNameExpression ktSimpleNameExpression;
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl = false;
                        KtConstructorCalleeExpression ktConstructorCalleeExpression = it.getCalleeExpression();
                        if (!Intrinsics.areEqual(ktConstructorCalleeExpression == null ? null : ((ktSimpleNameExpression = ktConstructorCalleeExpression.getConstructorReferenceExpression()) == null ? null : ktSimpleNameExpression.getReferencedName()), shortName)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                ktAnnotationEntry = v1;
            }
        }
        return ktAnnotationEntry;
    }

    private final String getLiteralStringFromAnnotation(KtAnnotationEntry annotation2) {
        KtExpression ktExpression;
        Object object = annotation2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object, "annotation.valueArguments");
        Object object2 = CollectionsKt.firstOrNull(object);
        KtExpression ktExpression2 = ktExpression = object2 == null ? null : object2.getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        Object object3 = object2 = argumentExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)argumentExpression : null;
        if (object2 == null) {
            return null;
        }
        Object stringTemplate = object2;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)stringTemplate).getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "stringTemplate.entries");
        Object object4 = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        Object object5 = object = object4 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object4 : null;
        if (object == null) {
            return null;
        }
        Object singleEntry = object;
        return ((KtLiteralStringTemplateEntry)singleEntry).getText();
    }

    static {
        String string2 = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string2;
        JVM_MULTIFILE_CLASS = new FqName("kotlin.jvm.JvmMultifileClass");
        string2 = JVM_MULTIFILE_CLASS.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "JVM_MULTIFILE_CLASS.shortName().asString()");
        JVM_MULTIFILE_CLASS_SHORT = string2;
        JVM_PACKAGE_NAME = new FqName("kotlin.jvm.JvmPackageName");
        string2 = JVM_PACKAGE_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "JVM_PACKAGE_NAME.shortName().asString()");
        JVM_PACKAGE_NAME_SHORT = string2;
    }
}

