/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0016J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "canBeValOccurrenceRanges", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "isDestructuring", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "properties", "canBeVal", "symbol", "value", "getDestructuringChildrenCount", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Ljava/lang/Integer;", "UninitializedPropertyReporter", "checkers"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();
    @NotNull
    private static final Set<EventOccurrencesRange> canBeValOccurrenceRanges;

    private CanBeValChecker() {
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter2, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data2, @NotNull Set<? extends FirPropertySymbol> properties2) {
        Object object;
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        boolean bl = false;
        Set unprocessedProperties = new LinkedHashSet();
        boolean bl2 = false;
        Map propertiesCharacteristics = new LinkedHashMap();
        UninitializedPropertyReporter reporterVisitor = new UninitializedPropertyReporter(data2, properties2, unprocessedProperties, propertiesCharacteristics);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
        for (FirPropertySymbol property2 : unprocessedProperties) {
            if (((FirProperty)property2.getFir()).getSource() instanceof FirFakeSourceElement || this.isDestructuring(property2)) continue;
            Map map2 = propertiesCharacteristics;
            object = EventOccurrencesRange.ZERO;
            boolean bl3 = false;
            map2.put(property2, object);
        }
        FirSourceElement lastDestructuringSource = null;
        boolean destructuringCanBeVal = false;
        int lastDestructuredVariables = 0;
        Object object2 = propertiesCharacteristics;
        boolean bl4 = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            DiagnosticReporter $this$report$iv2;
            boolean bl5;
            FirSourceElement it$iv;
            boolean bl6;
            boolean bl7;
            FirSourceElement firSourceElement;
            FirSourceElement firSourceElement2;
            boolean $i$f$report;
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv;
            FirSourceElement source;
            FirSourceElement firSourceElement3;
            Object object3 = object2 = (Map.Entry)object.next();
            boolean bl8 = false;
            FirPropertySymbol symbol2 = (FirPropertySymbol)object3.getKey();
            Object object4 = object2;
            boolean bl9 = false;
            EventOccurrencesRange value2 = (EventOccurrencesRange)((Object)object4.getValue());
            Object object5 = ((FirProperty)symbol2.getFir()).getSource();
            if (object5 == null) {
                firSourceElement3 = null;
            } else {
                KtKeywordToken[] ktKeywordTokenArray = new KtKeywordToken[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
                firSourceElement3 = source = FirSourceChildrenKt.getChild$default((FirSourceElement)object5, SetsKt.setOf(ktKeywordTokenArray), 0, 1, 2, null);
            }
            if (this.isDestructuring(symbol2)) {
                lastDestructuringSource = source;
                object5 = this.getDestructuringChildrenCount(symbol2);
                if (object5 == null) continue;
                lastDestructuredVariables = (Integer)object5;
                destructuringCanBeVal = true;
                continue;
            }
            if (lastDestructuringSource != null) {
                if (lastDestructuredVariables == 1 && destructuringCanBeVal && this.canBeVal(symbol2, value2)) {
                    object5 = reporter2;
                    factory$iv = FirErrors.INSTANCE.getCAN_BE_VAL();
                    $i$f$report = false;
                    firSourceElement = firSourceElement2 = lastDestructuringSource;
                    bl7 = false;
                    bl6 = false;
                    it$iv = firSourceElement;
                    bl5 = false;
                    $this$report$iv2.report((FirDiagnostic)factory$iv.on(it$iv));
                    lastDestructuringSource = null;
                } else if (!this.canBeVal(symbol2, value2)) {
                    destructuringCanBeVal = false;
                }
                int $this$report$iv2 = lastDestructuredVariables;
                lastDestructuredVariables = $this$report$iv2 + -1;
                continue;
            }
            if (!this.canBeVal(symbol2, value2) || ((FirProperty)symbol2.getFir()).getDelegate() != null) continue;
            $this$report$iv2 = reporter2;
            factory$iv = FirErrors.INSTANCE.getCAN_BE_VAL();
            $i$f$report = false;
            firSourceElement2 = source;
            if (firSourceElement2 == null) continue;
            firSourceElement = firSourceElement2;
            bl7 = false;
            bl6 = false;
            it$iv = firSourceElement;
            bl5 = false;
            $this$report$iv2.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }

    private final boolean canBeVal(FirPropertySymbol symbol2, EventOccurrencesRange value2) {
        return canBeValOccurrenceRanges.contains((Object)value2) && ((FirProperty)symbol2.getFir()).isVar();
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getDestructuringChildrenCount(FirPropertySymbol $this$getDestructuringChildrenCount) {
        Integer n;
        FirSourceElement firSourceElement = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
        if (firSourceElement instanceof FirPsiSourceElement) {
            PsiElement[] psiElementArray;
            PsiElement psiElement = FirSourceElementKt.getPsi((FirElement)$this$getDestructuringChildrenCount.getFir());
            PsiElement[] psiElementArray2 = psiElementArray = psiElement == null ? null : psiElement.getChildren();
            if (psiElementArray == null) {
                n = null;
            } else {
                int n2 = psiElementArray.length;
                n = n2 - 1;
            }
        } else if (firSourceElement instanceof FirLightSourceElement) {
            void $this$filterTo$iv$iv;
            FirSourceElement firSourceElement2 = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
            if (firSourceElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirLightSourceElement");
            }
            FirLightSourceElement source = (FirLightSourceElement)firSourceElement2;
            FirSourceElement firSourceElement3 = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
            if (firSourceElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirLightSourceElement");
            }
            FlyweightCapableTreeStructure<LighterASTNode> tree = ((FirLightSourceElement)firSourceElement3).getTreeStructure();
            List<LighterASTNode> children2 = SourceHelpersKt.getChildren(source.getLighterASTNode(), tree);
            Iterable $this$filter$iv = children2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                LighterASTNode lighterASTNode2 = it;
                if (!Intrinsics.areEqual(lighterASTNode2 == null ? null : lighterASTNode2.getTokenType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = null;
        }
        return n;
    }

    private final boolean isDestructuring(FirPropertySymbol $this$isDestructuring) {
        return Intrinsics.areEqual($this$isDestructuring.getCallableId().getCallableName().asString(), "<destruct>");
    }

    static {
        EventOccurrencesRange[] eventOccurrencesRangeArray = new EventOccurrencesRange[]{EventOccurrencesRange.EXACTLY_ONCE, EventOccurrencesRange.AT_MOST_ONCE, EventOccurrencesRange.ZERO};
        canBeValOccurrenceRanges = SetsKt.setOf(eventOccurrencesRangeArray);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$UninitializedPropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "unprocessedProperties", "", "propertiesCharacteristics", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getPropertiesCharacteristics", "getUnprocessedProperties", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class UninitializedPropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirPropertySymbol> unprocessedProperties;
        @NotNull
        private final Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics;

        public UninitializedPropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data2, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<FirPropertySymbol> unprocessedProperties, @NotNull Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Intrinsics.checkNotNullParameter(localProperties, "localProperties");
            Intrinsics.checkNotNullParameter(unprocessedProperties, "unprocessedProperties");
            Intrinsics.checkNotNullParameter(propertiesCharacteristics, "propertiesCharacteristics");
            this.data = data2;
            this.localProperties = localProperties;
            this.unprocessedProperties = unprocessedProperties;
            this.propertiesCharacteristics = propertiesCharacteristics;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirPropertySymbol> getUnprocessedProperties() {
            return this.unprocessedProperties;
        }

        @NotNull
        public final Map<FirPropertySymbol, EventOccurrencesRange> getPropertiesCharacteristics() {
            return this.propertiesCharacteristics;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            FirPropertySymbol firPropertySymbol;
            Intrinsics.checkNotNullParameter(node, "node");
            Object object = node.getFir().getCalleeReference();
            Object object2 = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = object2 == null ? null : ((FirResolvedNamedReference)object2).getResolvedSymbol();
            FirPropertySymbol firPropertySymbol2 = firPropertySymbol = abstractFirBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)abstractFirBasedSymbol : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            this.unprocessedProperties.remove(symbol2);
            EventOccurrencesRange currentCharacteristic = this.propertiesCharacteristics.getOrDefault(symbol2, EventOccurrencesRange.ZERO);
            PathAwarePropertyInitializationInfo info = MapsKt.getValue(this.data, node);
            object2 = this.propertiesCharacteristics;
            object = (EventOccurrencesRange)((Object)((PropertyInitializationInfo)info.getInfoAtNormalPath$checkers()).get(symbol2));
            object = currentCharacteristic.or((EventOccurrencesRange)((Object)(object == null ? EventOccurrencesRange.ZERO : object)));
            boolean bl = false;
            object2.put(symbol2, object);
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            if (node.getFir().getInitializer() == null && node.getFir().getDelegate() == null) {
                this.unprocessedProperties.add(symbol2);
            } else {
                Map<FirPropertySymbol, EventOccurrencesRange> map2 = this.propertiesCharacteristics;
                EventOccurrencesRange eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                boolean bl = false;
                map2.put(symbol2, eventOccurrencesRange);
            }
        }
    }
}

