/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeStubDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirErrorTypeRefImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J)\u0010 \u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\"2\u0006\u0010\u001c\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\"2\u0006\u0010\u001c\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010#R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/impl/FirErrorExpressionImpl;", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)V", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "getAnnotations", "()Ljava/util/List;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "acceptChildren", "", "R", "D", "visitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "data", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;Ljava/lang/Object;)V", "replaceTypeRef", "newTypeRef", "transformAnnotations", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "(Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirErrorExpressionImpl;", "transformChildren", "tree"})
public final class FirErrorExpressionImpl
extends FirErrorExpression {
    @Nullable
    private final FirSourceElement source;
    @NotNull
    private final ConeDiagnostic diagnostic;
    @NotNull
    private FirTypeRef typeRef;

    public FirErrorExpressionImpl(@Nullable FirSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        this.source = source;
        this.diagnostic = diagnostic;
        this.typeRef = new FirErrorTypeRefImpl(this.getSource(), new ConeStubDiagnostic(this.getDiagnostic()));
    }

    @Override
    @Nullable
    public FirSourceElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public ConeDiagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    @NotNull
    public FirTypeRef getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(@NotNull FirTypeRef firTypeRef) {
        Intrinsics.checkNotNullParameter(firTypeRef, "<set-?>");
        this.typeRef = firTypeRef;
    }

    @Override
    @NotNull
    public List<FirAnnotationCall> getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    public <R, D> void acceptChildren(@NotNull FirVisitor<? extends R, ? super D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        this.getTypeRef().accept(visitor2, data2);
    }

    @Override
    @NotNull
    public <D> FirErrorExpressionImpl transformChildren(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.setTypeRef((FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)this.getTypeRef(), transformer2, data2));
        return this;
    }

    @Override
    @NotNull
    public <D> FirErrorExpressionImpl transformAnnotations(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        return this;
    }

    @Override
    public void replaceTypeRef(@NotNull FirTypeRef newTypeRef) {
        Intrinsics.checkNotNullParameter(newTypeRef, "newTypeRef");
        this.setTypeRef(newTypeRef);
    }
}

