/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    @Override
    protected Void emptyResult(@NotNull TranslationContext context2) {
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$1(0);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    public final Void visitProperty(@NotNull KtProperty property2, @NotNull TranslationContext context2) {
        if (property2 == null) {
            InitializerVisitor.$$$reportNull$$$1(1);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$1(2);
        }
        if (property2 == null) {
            InitializerVisitor.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(2);
        }
        PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptor(context2.bindingContext(), property2);
        JsExpression value2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context2, property2);
        JsStatement statement2 = null;
        KtExpression initializer2 = property2.getInitializer();
        KtExpression delegate = property2.getDelegateExpression();
        if (initializer2 != null) {
            assert (value2 != null);
            KotlinType type2 = TranslationUtils.isReferenceToSyntheticBackingField(descriptor2) ? descriptor2.getType() : TranslationUtils.getReturnTypeForCoercion(descriptor2);
            value2 = TranslationUtils.coerce(context2, value2, type2);
            statement2 = InitializerUtils.generateInitializerForProperty(context2, descriptor2, value2);
        } else if (delegate != null) {
            assert (value2 != null);
            statement2 = InitializerUtils.generateInitializerForDelegate(context2, descriptor2, value2);
        } else if (Boolean.TRUE.equals(context2.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context2, descriptor2);
            JsExpression defaultValue2 = InitializerVisitor.generateDefaultValue(descriptor2, backingFieldReference);
            statement2 = TranslationUtils.assignmentToBackingField(context2, descriptor2, defaultValue2).source(property2).makeStmt();
        } else if (JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsNameRef propRef = new JsNameRef(context2.getNameForDescriptor(descriptor2), (JsExpression)new JsThisRef());
            JsExpression defaultValue3 = InitializerVisitor.generateDefaultValue(descriptor2, propRef);
            statement2 = JsAstUtils.assignment(propRef, defaultValue3).source(property2).makeStmt();
        }
        if (statement2 != null && !JsAstUtils.isEmptyStatement(statement2)) {
            context2.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(statement2));
        }
        return null;
    }

    @NotNull
    private static JsExpression generateDefaultValue(@NotNull PropertyDescriptor property2, @NotNull JsExpression lateInitDefault) {
        if (property2 == null) {
            InitializerVisitor.$$$reportNull$$$1(3);
        }
        if (lateInitDefault == null) {
            InitializerVisitor.$$$reportNull$$$1(4);
        }
        if (property2 == null) {
            InitializerVisitor.$$$reportNull$$$0(3);
        }
        if (lateInitDefault == null) {
            InitializerVisitor.$$$reportNull$$$0(4);
        }
        if (property2.isLateInit()) {
            JsExpression jsExpression = lateInitDefault.deepCopy();
            if (jsExpression == null) {
                InitializerVisitor.$$$reportNull$$$0(5);
            }
            if (jsExpression == null) {
                InitializerVisitor.$$$reportNull$$$1(5);
            }
            return jsExpression;
        }
        KotlinType type2 = property2.getType();
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isShort(type2)) {
            return new JsIntLiteral(0);
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return new JsBooleanLiteral(false);
        }
        return new JsNullLiteral();
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @NotNull TranslationContext context2) {
        KtExpression initializerBody;
        if (initializer2 == null) {
            InitializerVisitor.$$$reportNull$$$1(6);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$1(7);
        }
        if (initializer2 == null) {
            InitializerVisitor.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(7);
        }
        if ((initializerBody = initializer2.getBody()) != null) {
            context2.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializerBody, context2)));
        }
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull KtDeclaration expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            InitializerVisitor.$$$reportNull$$$1(8);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$1(9);
        }
        if (expression2 == null) {
            InitializerVisitor.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, TranslationContext data2) {
        if (constructor2 == null) {
            InitializerVisitor.$$$reportNull$$$1(10);
        }
        if (constructor2 == null) {
            InitializerVisitor.$$$reportNull$$$0(10);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lateInitDefault";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultValue";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitAnonymousInitializer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitSecondaryConstructor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lateInitDefault";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultValue";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitAnonymousInitializer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitSecondaryConstructor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

