/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.AnnotationDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.NullDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.StringDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.ValueParameterData;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\r\u00a8\u0006\u0015"}, d2={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParametersTypes", "", "Lorg/jetbrains/kotlin/load/java/descriptors/ValueParameterData;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getDefaultValueFromAnnotation", "Lorg/jetbrains/kotlin/load/java/descriptors/AnnotationDefaultValue;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DescriptorWithContainerSource;", "getParameterNameAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isFromJvmPackagePart", "", "descriptors.jvm"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<ValueParameterData> newValueParametersTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(newValueParametersTypes, "newValueParametersTypes");
        Intrinsics.checkNotNullParameter(oldValueParameters, "oldValueParameters");
        Intrinsics.checkNotNullParameter(newOwner, "newOwner");
        boolean bl = newValueParametersTypes.size() == oldValueParameters.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UtilKt$copyValueParameters$22 = false;
            String $i$a$-assert-UtilKt$copyValueParameters$22 = "Different value parameters sizes: Enhanced = " + newValueParametersTypes.size() + ", Old = " + oldValueParameters.size();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-UtilKt$copyValueParameters$22));
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)newValueParametersTypes, (Iterable)oldValueParameters);
        boolean $i$f$map = false;
        Iterable $i$a$-assert-UtilKt$copyValueParameters$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$newParameter$oldParameter;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            ValueParameterData newParameter = (ValueParameterData)$dstr$newParameter$oldParameter.component1();
            ValueParameterDescriptor oldParameter = (ValueParameterDescriptor)$dstr$newParameter$oldParameter.component2();
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Object object = oldParameter.getName();
            Intrinsics.checkNotNullExpressionValue(object, "oldParameter.name");
            Name name2 = object;
            KotlinType kotlinType = newParameter.getType();
            boolean bl4 = newParameter.getHasDefaultValue();
            boolean bl5 = oldParameter.isCrossinline();
            boolean bl6 = oldParameter.isNoinline();
            KotlinType kotlinType2 = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType(newParameter.getType()) : null;
            object = oldParameter.getSource();
            Intrinsics.checkNotNullExpressionValue(object, "oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, null, n, annotations2, name2, kotlinType, bl4, bl5, bl6, kotlinType2, (SourceElement)object);
            collection.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $this$getParentJavaStaticClassScope) {
        Intrinsics.checkNotNullParameter($this$getParentJavaStaticClassScope, "<this>");
        Object object = DescriptorUtilsKt.getSuperClassNotAny($this$getParentJavaStaticClassScope);
        if (object == null) {
            return null;
        }
        Object superClassDescriptor = object;
        MemberScope memberScope2 = superClassDescriptor.getStaticScope();
        object = memberScope2 instanceof LazyJavaStaticClassScope ? (LazyJavaStaticClassScope)memberScope2 : null;
        return object == null ? UtilKt.getParentJavaStaticClassScope((ClassDescriptor)superClassDescriptor) : object;
    }

    @Nullable
    public static final JvmClassName getImplClassNameForDeserialized(@NotNull DescriptorWithContainerSource $this$getImplClassNameForDeserialized) {
        Intrinsics.checkNotNullParameter($this$getImplClassNameForDeserialized, "<this>");
        DeserializedContainerSource deserializedContainerSource = $this$getImplClassNameForDeserialized.getContainerSource();
        JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
        return jvmPackagePartSource == null ? null : jvmPackagePartSource.getClassName();
    }

    public static final boolean isFromJvmPackagePart(@NotNull DescriptorWithContainerSource $this$isFromJvmPackagePart) {
        Intrinsics.checkNotNullParameter($this$isFromJvmPackagePart, "<this>");
        return $this$isFromJvmPackagePart.getContainerSource() instanceof JvmPackagePartSource;
    }

    @Nullable
    public static final AnnotationDescriptor getParameterNameAnnotation(@NotNull ValueParameterDescriptor $this$getParameterNameAnnotation) {
        Boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter($this$getParameterNameAnnotation, "<this>");
        Annotations annotations2 = $this$getParameterNameAnnotation.getAnnotations();
        Object object2 = JvmAnnotationNames.PARAMETER_NAME_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue(object2, "PARAMETER_NAME_FQ_NAME");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation((FqName)object2);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        object2 = DescriptorUtilsKt.firstArgument(annotation2);
        if (object2 == null) {
            object = null;
        } else {
            ConstantValue<?> $this$safeAs$iv = object2;
            boolean $i$f$safeAs = false;
            ConstantValue<?> constantValue = $this$safeAs$iv;
            if (!(constantValue instanceof StringValue)) {
                constantValue = null;
            }
            object = annotationDescriptor = (StringValue)constantValue;
        }
        if (annotationDescriptor == null) {
            bl = null;
        } else {
            object2 = (String)((ConstantValue)((Object)annotationDescriptor)).getValue();
            if (object2 == null) {
                bl = null;
            } else {
                CharSequence charSequence = (CharSequence)object2;
                boolean bl2 = false;
                bl = charSequence.length() == 0;
            }
        }
        if (!Intrinsics.areEqual(bl, false)) {
            return null;
        }
        return annotation2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AnnotationDefaultValue getDefaultValueFromAnnotation(@NotNull ValueParameterDescriptor $this$getDefaultValueFromAnnotation) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter($this$getDefaultValueFromAnnotation, "<this>");
        Annotations annotations2 = $this$getDefaultValueFromAnnotation.getAnnotations();
        ConstantValue<?> constantValue = JvmAnnotationNames.DEFAULT_VALUE_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue(constantValue, "DEFAULT_VALUE_FQ_NAME");
        Object object3 = annotations2.findAnnotation((FqName)((Object)constantValue));
        if (object3 == null) {
            object2 = null;
        } else {
            constantValue = DescriptorUtilsKt.firstArgument((AnnotationDescriptor)object3);
            if (constantValue == null) {
                object2 = null;
            } else {
                void $this$safeAs$iv;
                ConstantValue<?> constantValue2 = constantValue;
                boolean $i$f$safeAs = false;
                Object v2 = $this$safeAs$iv;
                if (!(v2 instanceof StringValue)) {
                    v2 = null;
                }
                object2 = object = (StringValue)v2;
            }
        }
        if (object != null && (object3 = (String)((ConstantValue)object).getValue()) != null) {
            constantValue = object3;
            boolean bl = false;
            boolean bl2 = false;
            ConstantValue<?> it = constantValue;
            boolean bl3 = false;
            return new StringDefaultValue((String)((Object)it));
        }
        Annotations annotations3 = $this$getDefaultValueFromAnnotation.getAnnotations();
        object = JvmAnnotationNames.DEFAULT_NULL_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue(object, "DEFAULT_NULL_FQ_NAME");
        if (annotations3.hasAnnotation((FqName)object)) {
            return NullDefaultValue.INSTANCE;
        }
        return null;
    }
}

