/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.FilteringIterator;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private final KotlinSuppressCache suppressCache;
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull KotlinSuppressCache suppressCache, @NotNull Collection<Diagnostic> diagnostics2) {
        if (suppressCache == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(0);
        }
        if (diagnostics2 == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(1);
        }
        this.diagnostics = diagnostics2;
        this.suppressCache = suppressCache;
        this.elementsCache = new DiagnosticsElementsCache(this, suppressCache.getFilter());
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        return new SimpleDiagnostics((Collection<? extends Diagnostic>)this.diagnostics);
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        return new FilteringIterator(this.diagnostics.iterator(), this.suppressCache.getFilter()::invoke);
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List<Diagnostic> list2 = CollectionsKt.filter(this.diagnostics, this.suppressCache.getFilter());
        if (list2 == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(3);
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

