/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitsExtensionsResolutionFilter;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.extensions.ExtraImportsProviderExtension;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.FileScopesCustomizer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplCodeAnalyzerKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ResettableSnippetsHistory;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.SourceCodeByReplLine;
import org.jetbrains.kotlin.scripting.definitions.ScriptPriorities;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u00049:;<B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J,\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0-2\u0006\u0010)\u001a\u00020.2\u0006\u0010/\u001a\u000200J&\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0-2\u0006\u0010)\u001a\u000203H\u0002J\f\u00104\u001a\b\u0012\u0004\u0012\u0002030-J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002030-2\u0006\u00106\u001a\u000207J\u001e\u00108\u001a\u00020\u001e2\u0006\u00102\u001a\u00020(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0-H\u0004R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase;", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "implicitsResolutionFilter", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitsExtensionsResolutionFilter;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Lorg/jetbrains/kotlin/resolve/BindingTraceContext;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitsExtensionsResolutionFilter;)V", "container", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "getContainer", "()Lorg/jetbrains/kotlin/container/ComponentProvider;", "module", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "replState", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState;", "getReplState", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "getResolveSession", "()Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "scriptDeclarationFactory", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ScriptMutableDeclarationProviderFactory;", "getScriptDeclarationFactory", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ScriptMutableDeclarationProviderFactory;", "topDownAnalysisContext", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "getTopDownAnalysisContext", "()Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalyzer", "Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "analyzeReplLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "analyzeReplLineWithImportedScripts", "importedScripts", "", "Lkotlin/script/experimental/api/SourceCode;", "priority", "", "doAnalyze", "linePsi", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/SourceCodeByReplLine;", "reset", "resetToLine", "lineId", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "runAnalyzer", "CompiledCode", "ReplLineAnalysisResult", "ResettableAnalyzerState", "ScriptMutableDeclarationProviderFactory", "kotlin-scripting-compiler"})
public class ReplCodeAnalyzerBase {
    @NotNull
    private final BindingTraceContext trace;
    @NotNull
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;
    @NotNull
    private final ComponentProvider container;
    @NotNull
    private final TopDownAnalysisContext topDownAnalysisContext;
    @NotNull
    private final LazyTopDownAnalyzer topDownAnalyzer;
    @NotNull
    private final ResolveSession resolveSession;
    @NotNull
    private final ResettableAnalyzerState replState;
    @NotNull
    private final ModuleDescriptorImpl module;

    public ReplCodeAnalyzerBase(@NotNull KotlinCoreEnvironment environment2, @NotNull BindingTraceContext trace, @Nullable ImplicitsExtensionsResolutionFilter implicitsResolutionFilter) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
        this.replState = new ResettableAnalyzerState();
        ComponentProvider $this$get$iv = this.container = TopDownAnalyzerFacadeForJVM.createContainer$default(TopDownAnalyzerFacadeForJVM.INSTANCE, environment2.getProject(), CollectionsKt.emptyList(), this.trace, environment2.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>(environment2){

            @Override
            @NotNull
            public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope p0) {
                Intrinsics.checkParameterIsNotNull(p0, "p0");
                return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p0);
            }

            @Override
            @NotNull
            public final String getSignature() {
                return "createPackagePartProvider(Lcom/intellij/psi/search/GlobalSearchScope;)Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;";
            }

            @Override
            @NotNull
            public final String getName() {
                return "createPackagePartProvider";
            }

            @Override
            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class);
            }
        }, 2.INSTANCE, null, null, null, implicitsResolutionFilter, 448, null);
        boolean $i$f$get = false;
        this.module = DslKt.getService($this$get$iv, ModuleDescriptorImpl.class);
        $this$get$iv = this.container;
        $i$f$get = false;
        this.scriptDeclarationFactory = DslKt.getService($this$get$iv, ScriptMutableDeclarationProviderFactory.class);
        $this$get$iv = this.container;
        $i$f$get = false;
        this.resolveSession = DslKt.getService($this$get$iv, ResolveSession.class);
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.TopLevelDeclarations, DataFlowInfoFactory.EMPTY, this.resolveSession.getDeclarationScopeProvider());
        $this$get$iv = this.container;
        $i$f$get = false;
        this.topDownAnalyzer = DslKt.getService($this$get$iv, LazyTopDownAnalyzer.class);
    }

    public /* synthetic */ ReplCodeAnalyzerBase(KotlinCoreEnvironment kotlinCoreEnvironment, BindingTraceContext bindingTraceContext, ImplicitsExtensionsResolutionFilter implicitsExtensionsResolutionFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bindingTraceContext = new NoScopeRecordCliBindingTrace();
        }
        if ((n & 4) != 0) {
            implicitsExtensionsResolutionFilter = null;
        }
        this(kotlinCoreEnvironment, bindingTraceContext, implicitsExtensionsResolutionFilter);
    }

    @NotNull
    public final BindingTraceContext getTrace() {
        return this.trace;
    }

    @NotNull
    protected final ScriptMutableDeclarationProviderFactory getScriptDeclarationFactory() {
        return this.scriptDeclarationFactory;
    }

    @NotNull
    protected final ComponentProvider getContainer() {
        return this.container;
    }

    @NotNull
    protected final TopDownAnalysisContext getTopDownAnalysisContext() {
        return this.topDownAnalysisContext;
    }

    @NotNull
    protected final ResolveSession getResolveSession() {
        return this.resolveSession;
    }

    @NotNull
    protected final ResettableAnalyzerState getReplState() {
        return this.replState;
    }

    @NotNull
    public final ModuleDescriptorImpl getModule() {
        return this.module;
    }

    @NotNull
    public final List<SourceCodeByReplLine> resetToLine(@NotNull ILineId lineId) {
        Intrinsics.checkParameterIsNotNull(lineId, "lineId");
        return this.replState.resetToLine(lineId);
    }

    @NotNull
    public final List<SourceCodeByReplLine> reset() {
        return this.replState.reset();
    }

    @NotNull
    public final ReplLineAnalysisResult analyzeReplLine(@NotNull KtFile psiFile, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        this.topDownAnalysisContext.getScripts().clear();
        this.trace.clearDiagnostics();
        KtScript ktScript = psiFile.getScript();
        if (ktScript == null) {
            Intrinsics.throwNpe();
        }
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, codeLine.getNo());
        return this.doAnalyze(psiFile, CollectionsKt.emptyList(), ReplCodeAnalyzerKt.toSourceCode(codeLine));
    }

    @NotNull
    public final ReplLineAnalysisResult analyzeReplLineWithImportedScripts(@NotNull KtFile psiFile, @NotNull List<? extends KtFile> importedScripts, @NotNull SourceCode codeLine, int priority) {
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        Intrinsics.checkParameterIsNotNull(importedScripts, "importedScripts");
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        this.topDownAnalysisContext.getScripts().clear();
        this.trace.clearDiagnostics();
        KtScript ktScript = psiFile.getScript();
        if (ktScript == null) {
            Intrinsics.throwNpe();
        }
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, priority);
        return this.doAnalyze(psiFile, importedScripts, ReplCodeAnalyzerKt.addNo(codeLine, priority));
    }

    @NotNull
    protected final TopDownAnalysisContext runAnalyzer(@NotNull KtFile linePsi, @NotNull List<? extends KtFile> importedScripts) {
        Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
        Intrinsics.checkParameterIsNotNull(importedScripts, "importedScripts");
        TopDownAnalysisMode topDownAnalysisMode = this.topDownAnalysisContext.getTopDownAnalysisMode();
        Intrinsics.checkExpressionValueIsNotNull((Object)topDownAnalysisMode, "topDownAnalysisContext.topDownAnalysisMode");
        return LazyTopDownAnalyzer.analyzeDeclarations$default(this.topDownAnalyzer, topDownAnalysisMode, CollectionsKt.plus((Collection)CollectionsKt.listOf(linePsi), (Iterable)importedScripts), null, 4, null);
    }

    private final ReplLineAnalysisResult doAnalyze(KtFile linePsi, List<? extends KtFile> importedScripts, SourceCodeByReplLine codeLine) {
        ReplLineAnalysisResult replLineAnalysisResult;
        boolean hasErrors;
        Diagnostics diagnostics2;
        TopDownAnalysisContext context2;
        block6: {
            boolean bl;
            this.scriptDeclarationFactory.setDelegateFactory(new FileBasedDeclarationProviderFactory(this.resolveSession.getStorageManager(), CollectionsKt.plus((Collection)CollectionsKt.listOf(linePsi), (Iterable)importedScripts)));
            this.replState.submitLine(linePsi);
            context2 = this.runAnalyzer(linePsi, importedScripts);
            Diagnostics diagnostics3 = this.trace.getBindingContext().getDiagnostics();
            Intrinsics.checkExpressionValueIsNotNull(diagnostics3, "trace.bindingContext.diagnostics");
            diagnostics2 = diagnostics3;
            Iterable $this$any$iv = diagnostics2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    bl = true;
                    break block6;
                }
                bl = hasErrors = false;
            }
        }
        if (hasErrors) {
            this.replState.lineFailure(linePsi);
            replLineAnalysisResult = new ReplLineAnalysisResult.WithErrors(diagnostics2);
        } else {
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = context2.getScripts().get(linePsi.getScript());
            if (classDescriptorWithResolutionScopes == null) {
                Intrinsics.throwNpe();
            }
            ClassDescriptorWithResolutionScopes scriptDescriptor = classDescriptorWithResolutionScopes;
            this.replState.lineSuccess(linePsi, codeLine, scriptDescriptor);
            replLineAnalysisResult = new ReplLineAnalysisResult.Successful(scriptDescriptor, diagnostics2);
        }
        return replLineAnalysisResult;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "Successful", "WithErrors", "kotlin-scripting-compiler"})
    public static interface ReplLineAnalysisResult {
        @Nullable
        public ClassDescriptorWithResolutionScopes getScriptDescriptor();

        @NotNull
        public Diagnostics getDiagnostics();

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult$Successful;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-scripting-compiler"})
        public static final class Successful
        implements ReplLineAnalysisResult {
            @NotNull
            private final ClassDescriptorWithResolutionScopes scriptDescriptor;
            @NotNull
            private final Diagnostics diagnostics;

            public Successful(@NotNull ClassDescriptorWithResolutionScopes scriptDescriptor, @NotNull Diagnostics diagnostics2) {
                Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
                Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
                this.scriptDescriptor = scriptDescriptor;
                this.diagnostics = diagnostics2;
            }

            @Override
            @NotNull
            public ClassDescriptorWithResolutionScopes getScriptDescriptor() {
                return this.scriptDescriptor;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            @NotNull
            public final ClassDescriptorWithResolutionScopes component1() {
                return this.scriptDescriptor;
            }

            @NotNull
            public final Diagnostics component2() {
                return this.diagnostics;
            }

            @NotNull
            public final Successful copy(@NotNull ClassDescriptorWithResolutionScopes scriptDescriptor, @NotNull Diagnostics diagnostics2) {
                Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
                Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
                return new Successful(scriptDescriptor, diagnostics2);
            }

            public static /* synthetic */ Successful copy$default(Successful successful, ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes, Diagnostics diagnostics2, int n, Object object) {
                if ((n & 1) != 0) {
                    classDescriptorWithResolutionScopes = successful.scriptDescriptor;
                }
                if ((n & 2) != 0) {
                    diagnostics2 = successful.diagnostics;
                }
                return successful.copy(classDescriptorWithResolutionScopes, diagnostics2);
            }

            @NotNull
            public String toString() {
                return "Successful(scriptDescriptor=" + this.scriptDescriptor + ", diagnostics=" + this.diagnostics + ')';
            }

            public int hashCode() {
                int result2 = this.scriptDescriptor.hashCode();
                result2 = result2 * 31 + this.diagnostics.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Successful)) {
                    return false;
                }
                Successful successful = (Successful)other;
                if (!Intrinsics.areEqual(this.scriptDescriptor, successful.scriptDescriptor)) {
                    return false;
                }
                return Intrinsics.areEqual(this.diagnostics, successful.diagnostics);
            }
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult$WithErrors;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ReplLineAnalysisResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-scripting-compiler"})
        public static final class WithErrors
        implements ReplLineAnalysisResult {
            @NotNull
            private final Diagnostics diagnostics;

            public WithErrors(@NotNull Diagnostics diagnostics2) {
                Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
                this.diagnostics = diagnostics2;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            @Override
            @Nullable
            public ClassDescriptorWithResolutionScopes getScriptDescriptor() {
                return null;
            }

            @NotNull
            public final Diagnostics component1() {
                return this.diagnostics;
            }

            @NotNull
            public final WithErrors copy(@NotNull Diagnostics diagnostics2) {
                Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
                return new WithErrors(diagnostics2);
            }

            public static /* synthetic */ WithErrors copy$default(WithErrors withErrors, Diagnostics diagnostics2, int n, Object object) {
                if ((n & 1) != 0) {
                    diagnostics2 = withErrors.diagnostics;
                }
                return withErrors.copy(diagnostics2);
            }

            @NotNull
            public String toString() {
                return "WithErrors(diagnostics=" + this.diagnostics + ')';
            }

            public int hashCode() {
                return this.diagnostics.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithErrors)) {
                    return false;
                }
                WithErrors withErrors = (WithErrors)other;
                return Intrinsics.areEqual(this.diagnostics, withErrors.diagnostics);
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ScriptMutableDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProviderFactory;", "()V", "delegateFactory", "rootPackageProvider", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "diagnoseMissingPackageFragment", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "packageFqName", "setDelegateFactory", "AdaptablePackageMemberDeclarationProvider", "kotlin-scripting-compiler"})
    protected static final class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        public final void setDelegateFactory(@NotNull DeclarationProviderFactory delegateFactory) {
            PackageMemberDeclarationProvider packageMemberDeclarationProvider;
            Intrinsics.checkParameterIsNotNull(delegateFactory, "delegateFactory");
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider packageMemberDeclarationProvider2 = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (packageMemberDeclarationProvider2 == null) {
                Intrinsics.throwNpe();
            }
            PackageMemberDeclarationProvider provider = packageMemberDeclarationProvider = packageMemberDeclarationProvider2;
            try {
                packageMemberDeclarationProvider = this.rootPackageProvider;
                if (packageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                    throw null;
                }
                ((AdaptablePackageMemberDeclarationProvider)packageMemberDeclarationProvider).addDelegateProvider(provider);
            }
            catch (UninitializedPropertyAccessException e) {
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(provider);
            }
        }

        @Override
        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
            Intrinsics.checkParameterIsNotNull(classLikeInfo, "classLikeInfo");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
                throw null;
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = declarationProviderFactory2.getClassMemberDeclarationProvider(classLikeInfo);
            Intrinsics.checkExpressionValueIsNotNull(classMemberDeclarationProvider, "delegateFactory.getClassMemberDeclarationProvider(classLikeInfo)");
            return classMemberDeclarationProvider;
        }

        @Override
        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            if (packageFqName.isRoot()) {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                    throw null;
                }
                return adaptablePackageMemberDeclarationProvider;
            }
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
                throw null;
            }
            return declarationProviderFactory2.getPackageMemberDeclarationProvider(packageFqName);
        }

        @Override
        public void diagnoseMissingPackageFragment(@NotNull FqName fqName2, @Nullable KtFile file2) {
            Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
                throw null;
            }
            declarationProviderFactory2.diagnoseMissingPackageFragment(fqName2, file2);
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/DelegatePackageMemberDeclarationProvider;", "delegateProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;)V", "addDelegateProvider", "", "provider", "kotlin-scripting-compiler"})
        public static final class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            @NotNull
            private PackageMemberDeclarationProvider delegateProvider;

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                Intrinsics.checkParameterIsNotNull(delegateProvider, "delegateProvider");
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }

            public final void addDelegateProvider(@NotNull PackageMemberDeclarationProvider provider) {
                List<Object> list2;
                CombinedPackageMemberDeclarationProvider combinedDelegateProvider;
                Intrinsics.checkParameterIsNotNull(provider, "provider");
                PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.delegateProvider;
                CombinedPackageMemberDeclarationProvider combinedPackageMemberDeclarationProvider = combinedDelegateProvider = packageMemberDeclarationProvider instanceof CombinedPackageMemberDeclarationProvider ? (CombinedPackageMemberDeclarationProvider)packageMemberDeclarationProvider : null;
                if (combinedDelegateProvider != null) {
                    list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(provider), (Iterable)combinedDelegateProvider.getProviders());
                } else {
                    PackageMemberDeclarationProvider[] packageMemberDeclarationProviderArray = new PackageMemberDeclarationProvider[]{provider, this.delegateProvider};
                    list2 = CollectionsKt.listOf(packageMemberDeclarationProviderArray);
                }
                List providers = list2;
                this.delegateProvider = new CombinedPackageMemberDeclarationProvider(providers);
                this.setDelegate(this.delegateProvider);
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$CompiledCode;", "", "className", "", "source", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/SourceCodeByReplLine;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/SourceCodeByReplLine;)V", "getClassName", "()Ljava/lang/String;", "getSource", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/SourceCodeByReplLine;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-scripting-compiler"})
    public static final class CompiledCode {
        @NotNull
        private final String className;
        @NotNull
        private final SourceCodeByReplLine source;

        public CompiledCode(@NotNull String className2, @NotNull SourceCodeByReplLine source) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            Intrinsics.checkParameterIsNotNull(source, "source");
            this.className = className2;
            this.source = source;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final SourceCodeByReplLine getSource() {
            return this.source;
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @NotNull
        public final SourceCodeByReplLine component2() {
            return this.source;
        }

        @NotNull
        public final CompiledCode copy(@NotNull String className2, @NotNull SourceCodeByReplLine source) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            Intrinsics.checkParameterIsNotNull(source, "source");
            return new CompiledCode(className2, source);
        }

        public static /* synthetic */ CompiledCode copy$default(CompiledCode compiledCode, String string2, SourceCodeByReplLine sourceCodeByReplLine, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = compiledCode.className;
            }
            if ((n & 2) != 0) {
                sourceCodeByReplLine = compiledCode.source;
            }
            return compiledCode.copy(string2, sourceCodeByReplLine);
        }

        @NotNull
        public String toString() {
            return "CompiledCode(className=" + this.className + ", source=" + this.source + ')';
        }

        public int hashCode() {
            int result2 = this.className.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompiledCode)) {
                return false;
            }
            CompiledCode compiledCode = (CompiledCode)other;
            if (!Intrinsics.areEqual(this.className, compiledCode.className)) {
                return false;
            }
            return Intrinsics.areEqual(this.source, compiledCode.source);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState;", "", "()V", "submittedLines", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo;", "Lkotlin/collections/HashMap;", "successfulLines", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ResettableSnippetsHistory;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "successfulLines$annotations", "computeFileScopes", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "lineInfo", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "lineFailure", "", "ktFile", "lineSuccess", "codeLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/SourceCodeByReplLine;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "reset", "", "resetToLine", "lineId", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "submitLine", "LineInfo", "kotlin-scripting-compiler"})
    public static final class ResettableAnalyzerState {
        @NotNull
        private final ResettableSnippetsHistory<LineInfo.SuccessfulLine> successfulLines = new ResettableSnippetsHistory(null, 1, null);
        @NotNull
        private final HashMap<KtFile, LineInfo> submittedLines;

        public ResettableAnalyzerState() {
            boolean bl = false;
            this.submittedLines = new HashMap();
        }

        private static /* synthetic */ void successfulLines$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SourceCodeByReplLine> resetToLine(@NotNull ILineId lineId) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(lineId, "lineId");
            List<Pair<SourceCodeByReplLine, LineInfo.SuccessfulLine>> removed2 = this.successfulLines.resetToLine(lineId);
            Iterable $this$forEach$iv = removed2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                this.submittedLines.remove(((LineInfo.SuccessfulLine)it.getSecond()).getLinePsi());
            }
            Iterable $this$map$iv = removed2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SourceCodeByReplLine sourceCodeByReplLine = (SourceCodeByReplLine)it.getFirst();
                collection.add(sourceCodeByReplLine);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SourceCodeByReplLine> reset() {
            void $this$mapTo$iv$iv;
            this.submittedLines.clear();
            Iterable $this$map$iv = this.successfulLines.reset();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SourceCodeByReplLine sourceCodeByReplLine = (SourceCodeByReplLine)it.getFirst();
                collection.add(sourceCodeByReplLine);
            }
            return (List)destination$iv$iv;
        }

        public final void submitLine(@NotNull KtFile ktFile) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            LineInfo.SubmittedLine line = new LineInfo.SubmittedLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue());
            Map map2 = this.submittedLines;
            boolean bl = false;
            map2.put(ktFile, line);
            FileScopeProviderKt.setFileScopesCustomizer(ktFile, new FileScopesCustomizer(this, ktFile){
                final /* synthetic */ ResettableAnalyzerState this$0;
                final /* synthetic */ KtFile $ktFile;
                {
                    this.this$0 = $receiver;
                    this.$ktFile = $ktFile;
                }

                @NotNull
                public FileScopes createFileScopes(@NotNull FileScopeFactory fileScopeFactory) {
                    FileScopes fileScopes;
                    Intrinsics.checkParameterIsNotNull(fileScopeFactory, "fileScopeFactory");
                    LineInfo lineInfo = ResettableAnalyzerState.access$lineInfo(this.this$0, this.$ktFile);
                    if (lineInfo == null) {
                        fileScopes = null;
                    } else {
                        LineInfo lineInfo2 = lineInfo;
                        ResettableAnalyzerState resettableAnalyzerState = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        LineInfo it = lineInfo2;
                        boolean bl3 = false;
                        fileScopes = ResettableAnalyzerState.access$computeFileScopes(resettableAnalyzerState, it, fileScopeFactory);
                    }
                    FileScopes fileScopes2 = fileScopes;
                    return fileScopes2 == null ? FileScopeFactory.createScopesForFile$default(fileScopeFactory, this.$ktFile, null, false, 6, null) : fileScopes2;
                }
            });
        }

        public final void lineSuccess(@NotNull KtFile ktFile, @NotNull SourceCodeByReplLine codeLine, @NotNull ClassDescriptorWithResolutionScopes scriptDescriptor) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            LineInfo.SuccessfulLine successfulLine = new LineInfo.SuccessfulLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue(), scriptDescriptor);
            Object object = this.submittedLines;
            boolean bl = false;
            object.put(ktFile, successfulLine);
            object = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(object, "ktFile.name");
            this.successfulLines.add(new CompiledCode((String)object, codeLine), successfulLine);
        }

        public final void lineFailure(@NotNull KtFile ktFile) {
            Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
            Map map2 = this.submittedLines;
            LineInfo.FailedLine failedLine = new LineInfo.FailedLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue());
            boolean bl = false;
            map2.put(ktFile, failedLine);
        }

        private final LineInfo lineInfo(KtFile ktFile) {
            return this.submittedLines.get(ktFile);
        }

        /*
         * Unable to fully structure code
         */
        private final FileScopes computeFileScopes(LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
            block6: {
                linePsi = lineInfo.getLinePsi();
                var5_4 = linePsi.getImportDirectives();
                var6_5 = false;
                if (var5_4.isEmpty() == false) ** GOTO lbl-1000
                var5_4 = linePsi.getProject();
                Intrinsics.checkExpressionValueIsNotNull(var5_4, "linePsi.project");
                var5_4 = ExtraImportsProviderExtension.Companion.getInstance((Project)var5_4).getExtraImports(linePsi);
                var6_5 = false;
                if (var5_4.isEmpty() == false) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                hasImports = v0;
                var8_8 = lineInfo.getParentLine();
                if (var8_8 == null) {
                    v1 = null;
                } else {
                    var9_11 = var8_8.getLineDescriptor();
                    v1 = var7_12 = var9_11.getScopeForInitializerResolution();
                }
                if (var7_12 == null) {
                    return null;
                }
                lexicalScopeAfterLastLine = var6_6 = var7_12;
                $this$first$iv = ScopeUtilsKt.getParentsWithSelf(lexicalScopeAfterLastLine);
                $i$f$first = false;
                var9_11 = $this$first$iv.iterator();
                while (var9_11.hasNext()) {
                    element$iv = var9_11.next();
                    it = (HierarchicalScope)element$iv;
                    $i$a$-first-ReplCodeAnalyzerBase$ResettableAnalyzerState$computeFileScopes$lastLineImports$1 = false;
                    if (!(it instanceof ImportingScope)) continue;
                    break block6;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            lastLineImports = (ImportingScope)element$iv;
            scopesForThisLine = fileScopeFactory.createScopesForFile(linePsi, lastLineImports, false);
            combinedLexicalScopes = hasImports != false ? ScopeUtilsKt.replaceImportingScopes(lexicalScopeAfterLastLine, scopesForThisLine.getImportingScope()) : lexicalScopeAfterLastLine;
            return new FileScopes(combinedLexicalScopes, scopesForThisLine.getImportingScope(), scopesForThisLine.getImportForceResolver());
        }

        public static final /* synthetic */ LineInfo access$lineInfo(ResettableAnalyzerState $this, KtFile ktFile) {
            return $this.lineInfo(ktFile);
        }

        public static final /* synthetic */ FileScopes access$computeFileScopes(ResettableAnalyzerState $this, LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
            return $this.computeFileScopes(lineInfo, fileScopeFactory);
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo;", "", "()V", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "FailedLine", "SubmittedLine", "SuccessfulLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$FailedLine;", "kotlin-scripting-compiler"})
        private static abstract class LineInfo {
            private LineInfo() {
            }

            @NotNull
            public abstract KtFile getLinePsi();

            @Nullable
            public abstract SuccessfulLine getParentLine();

            public /* synthetic */ LineInfo(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class SubmittedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                public SubmittedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }
            }

            @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "lineDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;)V", "getLineDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class SuccessfulLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;
                @NotNull
                private final ClassDescriptorWithResolutionScopes lineDescriptor;

                public SuccessfulLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine, @NotNull ClassDescriptorWithResolutionScopes lineDescriptor) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    Intrinsics.checkParameterIsNotNull(lineDescriptor, "lineDescriptor");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                    this.lineDescriptor = lineDescriptor;
                }

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                @NotNull
                public final ClassDescriptorWithResolutionScopes getLineDescriptor() {
                    return this.lineDescriptor;
                }
            }

            @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class FailedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                public FailedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }
            }
        }
    }
}

