/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.type;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.type.MapPsiToAsmDesc;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/type/MapPsiToAsmDesc;", "", "()V", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "classDesc", "", "psiClass", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "error", "message", "methodDesc", "psiMethod", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiMethod;", "primitive", "kotlin.jvm.PlatformType", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "typeDesc", "type", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiType;", "unknownSignature", "util"})
public final class MapPsiToAsmDesc {
    @NotNull
    public static final MapPsiToAsmDesc INSTANCE = new MapPsiToAsmDesc();
    @NotNull
    private static final Logger LOG;

    private MapPsiToAsmDesc() {
    }

    @NotNull
    public final String typeDesc(@NotNull PsiType type2) {
        Object object;
        Intrinsics.checkNotNullParameter(type2, "type");
        PsiType psiType2 = type2;
        if (Intrinsics.areEqual(psiType2, PsiType.VOID)) {
            Type type3 = Type.VOID_TYPE;
            Intrinsics.checkNotNullExpressionValue(type3, "VOID_TYPE");
            Object object2 = this.primitive(type3);
            Intrinsics.checkNotNullExpressionValue(object2, "primitive(VOID_TYPE)");
            object = object2;
        } else if (Intrinsics.areEqual(psiType2, PsiType.BOOLEAN)) {
            Type type4 = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue(type4, "BOOLEAN_TYPE");
            String string2 = this.primitive(type4);
            Intrinsics.checkNotNullExpressionValue(string2, "primitive(BOOLEAN_TYPE)");
            object = string2;
        } else if (Intrinsics.areEqual(psiType2, PsiType.CHAR)) {
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue(type5, "CHAR_TYPE");
            String string3 = this.primitive(type5);
            Intrinsics.checkNotNullExpressionValue(string3, "primitive(CHAR_TYPE)");
            object = string3;
        } else if (Intrinsics.areEqual(psiType2, PsiType.INT)) {
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue(type6, "INT_TYPE");
            String string4 = this.primitive(type6);
            Intrinsics.checkNotNullExpressionValue(string4, "primitive(INT_TYPE)");
            object = string4;
        } else if (Intrinsics.areEqual(psiType2, PsiType.BYTE)) {
            Type type7 = Type.BYTE_TYPE;
            Intrinsics.checkNotNullExpressionValue(type7, "BYTE_TYPE");
            String string5 = this.primitive(type7);
            Intrinsics.checkNotNullExpressionValue(string5, "primitive(BYTE_TYPE)");
            object = string5;
        } else if (Intrinsics.areEqual(psiType2, PsiType.SHORT)) {
            Type type8 = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue(type8, "SHORT_TYPE");
            String string6 = this.primitive(type8);
            Intrinsics.checkNotNullExpressionValue(string6, "primitive(SHORT_TYPE)");
            object = string6;
        } else if (Intrinsics.areEqual(psiType2, PsiType.LONG)) {
            Type type9 = Type.LONG_TYPE;
            Intrinsics.checkNotNullExpressionValue(type9, "LONG_TYPE");
            String string7 = this.primitive(type9);
            Intrinsics.checkNotNullExpressionValue(string7, "primitive(LONG_TYPE)");
            object = string7;
        } else if (Intrinsics.areEqual(psiType2, PsiType.FLOAT)) {
            Type type10 = Type.FLOAT_TYPE;
            Intrinsics.checkNotNullExpressionValue(type10, "FLOAT_TYPE");
            String string8 = this.primitive(type10);
            Intrinsics.checkNotNullExpressionValue(string8, "primitive(FLOAT_TYPE)");
            object = string8;
        } else if (Intrinsics.areEqual(psiType2, PsiType.DOUBLE)) {
            Type type11 = Type.DOUBLE_TYPE;
            Intrinsics.checkNotNullExpressionValue(type11, "DOUBLE_TYPE");
            String string9 = this.primitive(type11);
            Intrinsics.checkNotNullExpressionValue(string9, "primitive(DOUBLE_TYPE)");
            object = string9;
        } else if (psiType2 instanceof PsiArrayType) {
            PsiType psiType3 = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkNotNullExpressionValue(psiType3, "type.componentType");
            object = Intrinsics.stringPlus("[", this.typeDesc(psiType3));
        } else if (psiType2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            PsiClass psiClass = resolved;
            if (psiClass instanceof PsiTypeParameter) {
                Object object3 = ((PsiTypeParameter)resolved).getSuperTypes();
                Intrinsics.checkNotNullExpressionValue(object3, "resolved.superTypes");
                PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])object3);
                if (psiClassType == null) {
                    object = "Ljava/lang/Object;";
                } else {
                    PsiClassType psiClassType2 = psiClassType;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiClassType it = psiClassType2;
                    boolean bl3 = false;
                    object3 = this.typeDesc(it);
                    object = object3 == null ? "Ljava/lang/Object;" : object3;
                }
            } else {
                object = psiClass != null ? this.classDesc(resolved) : this.unknownSignature();
            }
        } else {
            object = this.error("Unexpected type " + type2 + " of class " + type2.getClass());
        }
        return object;
    }

    private final String classDesc(PsiClass psiClass) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$classDesc_u24lambda_u2d2 = stringBuilder2;
        boolean bl5 = false;
        $this$classDesc_u24lambda_u2d2.append("L");
        List classes2 = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.generateSequence(psiClass, (Function1)classDesc.1.classes.1.INSTANCE)));
        String string2 = ((PsiClass)CollectionsKt.first(classes2)).getQualifiedName();
        Intrinsics.checkNotNull(string2);
        String string3 = string2;
        $this$classDesc_u24lambda_u2d2.append(StringsKt.replace$default(string3, ".", "/", false, 4, null));
        Iterable $this$forEach$iv = CollectionsKt.drop(classes2, 1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiClass it = (PsiClass)element$iv;
            boolean bl6 = false;
            $this$classDesc_u24lambda_u2d2.append("$");
            String string4 = it.getName();
            Intrinsics.checkNotNull(string4);
            $this$classDesc_u24lambda_u2d2.append(string4);
        }
        $this$classDesc_u24lambda_u2d2.append(";");
        String string5 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "StringBuilder().apply(builderAction).toString()");
        return string5;
    }

    @NotNull
    public final String methodDesc(@NotNull PsiMethod psiMethod) {
        String string2;
        Intrinsics.checkNotNullParameter(psiMethod, "psiMethod");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$methodDesc_u24lambda_u2d5 = stringBuilder2;
        boolean bl5 = false;
        $this$methodDesc_u24lambda_u2d5.append("(");
        Object object = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue(object, "psiMethod.parameterList.parameters");
        Object[] $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        for (Object object2 : $this$forEach$iv) {
            PsiParameter it = (PsiParameter)object2;
            boolean bl6 = false;
            PsiType psiType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue(psiType2, "it.type");
            $this$methodDesc_u24lambda_u2d5.append(this.typeDesc(psiType2));
        }
        $this$methodDesc_u24lambda_u2d5.append(")");
        StringBuilder stringBuilder3 = $this$methodDesc_u24lambda_u2d5;
        object = psiMethod.getReturnType();
        if (object == null) {
            string2 = "V";
        } else {
            Object[] objectArray = object;
            int n = 0;
            int n2 = 0;
            Object[] objectArray2 = objectArray;
            StringBuilder stringBuilder4 = stringBuilder3;
            boolean bl7 = false;
            String string3 = this.typeDesc((PsiType)objectArray2);
            stringBuilder3 = stringBuilder4;
            String string4 = string3;
            string2 = string4 == null ? "V" : string4;
        }
        stringBuilder3.append(string2);
        String string4 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final String unknownSignature() {
        return "";
    }

    private final String error(String message2) {
        LOG.error(message2);
        return this.unknownSignature();
    }

    private final String primitive(Type asmType) {
        return asmType.getDescriptor();
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(this::class.java)");
        LOG = logger;
    }
}

