/*
 * Decompiled with CFR 0.152.
 */
package org.jline.console;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.console.CmdDesc;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.terminal.Terminal;

public interface CommandRegistry {
    public static SystemCompleter aggregateCompleters(CommandRegistry ... commandRegistries) {
        SystemCompleter out = new SystemCompleter();
        for (CommandRegistry r : commandRegistries) {
            out.add(r.compileCompleters());
        }
        return out;
    }

    public static SystemCompleter compileCompleters(CommandRegistry ... commandRegistries) {
        SystemCompleter out = CommandRegistry.aggregateCompleters(commandRegistries);
        out.compile();
        return out;
    }

    default public String name() {
        return this.getClass().getSimpleName();
    }

    public Set<String> commandNames();

    public Map<String, String> commandAliases();

    public List<String> commandInfo(String var1);

    public boolean hasCommand(String var1);

    public SystemCompleter compileCompleters();

    default public CmdDesc commandDescription(List<String> args2) {
        return !args2.isEmpty() ? this.commandDescription(args2.get(0)) : this.commandDescription("");
    }

    public CmdDesc commandDescription(String var1);

    default public Object execute(CommandSession session2, String command, String[] args2) throws Exception {
        throw new IllegalArgumentException("CommandRegistry method execute(String command, String[] args) is not implemented!");
    }

    default public Object invoke(CommandSession session2, String command, Object ... args2) throws Exception {
        String[] _args = new String[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            if (!(args2[i] instanceof String)) {
                throw new IllegalArgumentException();
            }
            _args[i] = args2[i].toString();
        }
        return this.execute(session2, command, _args);
    }

    public static class CommandSession {
        private final Terminal terminal;
        private final InputStream in;
        private final PrintStream out;
        private final PrintStream err;

        public CommandSession() {
            this.in = System.in;
            this.out = System.out;
            this.err = System.err;
            this.terminal = null;
        }

        public CommandSession(Terminal terminal) {
            this(terminal, terminal.input(), new PrintStream(terminal.output()), new PrintStream(terminal.output()));
        }

        public CommandSession(Terminal terminal, InputStream in, PrintStream out, PrintStream err) {
            this.terminal = terminal;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }
}

