/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;

public class StringsCompleter
implements Completer {
    protected Collection<Candidate> candidates = new ArrayList<Candidate>();
    protected Supplier<Collection<String>> stringsSupplier;

    public StringsCompleter() {
    }

    public StringsCompleter(Supplier<Collection<String>> stringsSupplier) {
        assert (stringsSupplier != null);
        this.candidates = null;
        this.stringsSupplier = stringsSupplier;
    }

    public StringsCompleter(String ... strings2) {
        this((Iterable<String>)Arrays.asList(strings2));
    }

    public StringsCompleter(Iterable<String> strings2) {
        assert (strings2 != null);
        for (String string2 : strings2) {
            this.candidates.add(new Candidate(AttributedString.stripAnsi(string2), string2, null, null, null, null, true));
        }
    }

    public StringsCompleter(Candidate ... candidates2) {
        this((Collection<Candidate>)Arrays.asList(candidates2));
    }

    public StringsCompleter(Collection<Candidate> candidates2) {
        assert (candidates2 != null);
        this.candidates.addAll(candidates2);
    }

    @Override
    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates2) {
        assert (commandLine != null);
        assert (candidates2 != null);
        if (this.candidates != null) {
            candidates2.addAll(this.candidates);
        } else {
            for (String string2 : this.stringsSupplier.get()) {
                candidates2.add(new Candidate(AttributedString.stripAnsi(string2), string2, null, null, null, null, true));
            }
        }
    }
}

