/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingReader;

public class PosixPtyTerminal
extends AbstractPosixTerminal {
    private final InputStream in;
    private final OutputStream out;
    private final InputStream masterInput;
    private final OutputStream masterOutput;
    private final NonBlockingInputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Object lock = new Object();
    private Thread inputPumpThread;
    private Thread outputPumpThread;
    private boolean paused = true;

    public PosixPtyTerminal(String name2, String type2, Pty pty, InputStream in, OutputStream out, Charset encoding) throws IOException {
        this(name2, type2, pty, in, out, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public PosixPtyTerminal(String name2, String type2, Pty pty, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        this(name2, type2, pty, in, out, encoding, signalHandler, false);
    }

    public PosixPtyTerminal(String name2, String type2, Pty pty, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        super(name2, type2, pty, encoding, signalHandler);
        this.in = Objects.requireNonNull(in);
        this.out = Objects.requireNonNull(out);
        this.masterInput = pty.getMasterInput();
        this.masterOutput = pty.getMasterOutput();
        this.input = new InputStreamWrapper(NonBlocking.nonBlocking(name2, pty.getSlaveInput()));
        this.output = pty.getSlaveOutput();
        this.reader = NonBlocking.nonBlocking(name2, this.input, this.encoding());
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, this.encoding()));
        this.parseInfoCmp();
        if (!paused) {
            this.resume();
        }
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        this.reader.close();
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(boolean wait) throws InterruptedException {
        Thread p2;
        Thread p1;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            p1 = this.inputPumpThread;
            p2 = this.outputPumpThread;
        }
        if (p1 != null) {
            p1.interrupt();
        }
        if (p2 != null) {
            p2.interrupt();
        }
        if (p1 != null) {
            p1.join();
        }
        if (p2 != null) {
            p2.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.inputPumpThread == null) {
                this.inputPumpThread = new Thread(this::pumpIn, this.toString() + " input pump thread");
                this.inputPumpThread.setDaemon(true);
                this.inputPumpThread.start();
            }
            if (this.outputPumpThread == null) {
                this.outputPumpThread = new Thread(this::pumpOut, this.toString() + " output pump thread");
                this.outputPumpThread.setDaemon(true);
                this.outputPumpThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pumpIn() {
        try {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.inputPumpThread = null;
                        return;
                    }
                }
                int b = this.in.read();
                if (b < 0) {
                    this.input.close();
                    return;
                }
                this.masterOutput.write(b);
                this.masterOutput.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.inputPumpThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pumpOut() {
        try {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.outputPumpThread = null;
                        return;
                    }
                }
                int b = this.masterInput.read();
                if (b < 0) {
                    this.input.close();
                    break;
                }
                this.out.write(b);
                this.out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.outputPumpThread = null;
            }
        }
        try {
            this.close();
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class InputStreamWrapper
    extends NonBlockingInputStream {
        private final NonBlockingInputStream in;
        private final AtomicBoolean closed = new AtomicBoolean();

        protected InputStreamWrapper(NonBlockingInputStream in) {
            this.in = in;
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            if (this.closed.get()) {
                throw new ClosedException();
            }
            return this.in.read(timeout, isPeek);
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
        }
    }
}

