/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRunner
extends Runner
implements Filterable,
Sortable {
    private final List<Runner> fRunners = new ArrayList<Runner>();
    private final String fName;

    public CompositeRunner(String name2) {
        this.fName = name2;
    }

    @Override
    public void run(RunNotifier notifier) {
        for (Runner each : this.fRunners) {
            each.run(notifier);
        }
    }

    @Override
    public Description getDescription() {
        Description spec = Description.createSuiteDescription(this.fName);
        for (Runner runner : this.fRunners) {
            spec.addChild(runner.getDescription());
        }
        return spec;
    }

    public List<Runner> getRunners() {
        return this.fRunners;
    }

    public void addAll(List<? extends Runner> runners) {
        this.fRunners.addAll(runners);
    }

    public void add(Runner runner) {
        this.fRunners.add(runner);
    }

    @Override
    public void filter(Filter filter2) throws NoTestsRemainException {
        Iterator<Runner> iter = this.fRunners.iterator();
        while (iter.hasNext()) {
            Runner runner = iter.next();
            if (filter2.shouldRun(runner.getDescription())) {
                filter2.apply(runner);
                continue;
            }
            iter.remove();
        }
    }

    protected String getName() {
        return this.fName;
    }

    @Override
    public void sort(final Sorter sorter) {
        Collections.sort(this.fRunners, new Comparator<Runner>(){

            @Override
            public int compare(Runner o1, Runner o2) {
                return sorter.compare(o1.getDescription(), o2.getDescription());
            }
        });
        for (Runner each : this.fRunners) {
            sorter.apply(each);
        }
    }
}

