/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormatter;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001e\u0010\u000e\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocCommentsHelper;", "Lcom/google/googlejavaformat/CommentsHelper;", "lineSeparator", "", "maxLineLength", "", "(Ljava/lang/String;I)V", "LINE_COMMENT_MISSING_SPACE_PREFIX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "indentJavadoc", "lines", "", "column0", "indentLineComments", "javadocShaped", "", "preserveIndentation", "rewrite", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "maxWidth", "wrapLineComments", "ktfmt"})
public final class KDocCommentsHelper
implements CommentsHelper {
    @NotNull
    private final String lineSeparator;
    private final int maxLineLength;
    private final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX;

    public KDocCommentsHelper(@NotNull String lineSeparator, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this.lineSeparator = lineSeparator;
        this.maxLineLength = maxLineLength;
        this.LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");
    }

    @NotNull
    public String rewrite(@NotNull Input.Tok tok, int maxWidth, int column0) {
        Intrinsics.checkNotNullParameter((Object)tok, (String)"tok");
        if (!tok.isComment()) {
            String string = tok.getOriginalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tok.originalText");
            return string;
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            String string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            text = KDocFormatter.INSTANCE.formatKDoc(string, column0, this.maxLineLength);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator it = Newlines.lineIterator((String)text);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom((CharSequence)it.next()));
        }
        return tok.isSlashSlashComment() ? this.indentLineComments((List<String>)lines, column0) : (this.javadocShaped((List<String>)lines) ? this.indentJavadoc((List<String>)lines, column0) : this.preserveIndentation((List<String>)lines, column0));
    }

    private final String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            i = n++;
            int lineIdx = CharMatcher.whitespace().negate().indexIn(lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder.append(lines.get(0));
        n = 1;
        n2 = lines.size();
        while (n < n2) {
            i = n++;
            builder.append(this.lineSeparator).append(Strings.repeat(" ", column0));
            if (lines.get(i).length() >= startCol) {
                String string = lines.get(i).substring(startCol);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                builder.append(string);
                continue;
            }
            builder.append(lines.get(i));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String indentLineComments(List<String> lines, int column0) {
        List<String> lines2 = lines;
        lines2 = this.wrapLineComments(lines2, column0);
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)StringsKt.trim((CharSequence)lines2.get(0))).toString());
        String indentString = Strings.repeat(" ", column0);
        int n = 1;
        int n2 = lines2.size();
        while (n < n2) {
            int i = n++;
            builder.append(this.lineSeparator).append(indentString).append(((Object)StringsKt.trim((CharSequence)lines2.get(i))).toString());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final List<String> wrapLineComments(List<String> lines, int column0) {
        ArrayList<String> result = new ArrayList<String>();
        for (String originalLine : lines) {
            String string;
            String line2 = originalLine;
            Matcher matcher = this.LINE_COMMENT_MISSING_SPACE_PREFIX.matcher(line2);
            if (matcher.find()) {
                int length = matcher.group(1).length();
                StringBuilder stringBuilder = new StringBuilder().append(Strings.repeat("/", length)).append(' ');
                string = line2.substring(length);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                line2 = stringBuilder.append(string).toString();
            }
            if (StringsKt.startsWith$default((String)line2, (String)"// MOE:", (boolean)false, (int)2, null)) {
                result.add(line2);
                continue;
            }
            while (line2.length() + column0 > 100) {
                int idx = 100 - column0;
                while (idx >= 2 && !CharMatcher.whitespace().matches(line2.charAt(idx))) {
                    int n = idx;
                    idx = n + -1;
                }
                if (idx <= 2) break;
                String string2 = line2;
                int n = 0;
                String string3 = string2.substring(n, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                result.add(string3);
                string = line2.substring(idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                line2 = Intrinsics.stringPlus((String)"//", (Object)string);
            }
            result.add(line2);
        }
        return result;
    }

    private final String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)StringsKt.trim((CharSequence)lines.get(0))).toString());
        int indent = column0 + 1;
        String indentString = Strings.repeat(" ", indent);
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            int i = n++;
            builder.append(this.lineSeparator).append(indentString);
            String line2 = ((Object)StringsKt.trim((CharSequence)lines.get(i))).toString();
            if (!StringsKt.startsWith$default((String)line2, (String)"*", (boolean)false, (int)2, null)) {
                builder.append("* ");
            }
            builder.append(line2);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = ((Object)StringsKt.trim((CharSequence)it.next())).toString();
        if (StringsKt.startsWith$default((String)first, (String)"/**", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!StringsKt.startsWith$default((String)first, (String)"/*", (boolean)false, (int)2, null)) {
            return false;
        }
        while (it.hasNext()) {
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it.next())).toString(), (String)"*", (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }
}

