/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;

public class ClassContext
extends FieldOwnerContext<ClassDescriptor> {
    private final KotlinTypeMapper typeMapper;

    public ClassContext(@NotNull KotlinTypeMapper typeMapper, @NotNull ClassDescriptor contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable LocalLookup localLookup) {
        super(contextDescriptor, contextKind, parentContext, typeMapper.getBindingContext().get(CodegenBinding.CLOSURE, contextDescriptor), contextDescriptor, localLookup);
        this.typeMapper = typeMapper;
    }

    @Override
    @Nullable
    protected StackValue.Field computeOuterExpression() {
        ClassDescriptor enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        if (!CodegenBinding.canHaveOuter(this.typeMapper.getBindingContext(), (ClassDescriptor)this.getContextDescriptor())) {
            return null;
        }
        return StackValue.field(this.typeMapper.mapType(enclosingClass), this.typeMapper.mapType((ClassifierDescriptor)this.getContextDescriptor()), "this$0", false, StackValue.LOCAL_0, enclosingClass);
    }

    @Nullable
    public CodegenContext getCompanionObjectContext() {
        if (((ClassDescriptor)this.getContextDescriptor()).getCompanionObjectDescriptor() != null) {
            return this.findChildContext(((ClassDescriptor)this.getContextDescriptor()).getCompanionObjectDescriptor());
        }
        return null;
    }

    public String toString() {
        return "Class: " + this.getContextDescriptor();
    }
}

