/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.types.KotlinType;

public final class StringTemplateTranslator
extends AbstractTranslator {
    private final KtStringTemplateEntry[] expressionEntries;

    @NotNull
    public static JsExpression translate(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context) {
        return new StringTemplateTranslator(expression2, context).translate();
    }

    private StringTemplateTranslator(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expressionEntries = expression2.getEntries();
        assert (this.expressionEntries.length != 0) : ErrorReportingUtils.message(expression2, "String template must have one or more entries.");
    }

    @NotNull
    private JsExpression translate() {
        EntryVisitor entryVisitor = new EntryVisitor();
        for (KtStringTemplateEntry entry : this.expressionEntries) {
            entry.accept(entryVisitor);
        }
        return entryVisitor.getResultingExpression();
    }

    private final class EntryVisitor
    extends KtVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression2) {
            this.resultingExpression = this.resultingExpression == null ? expression2 : JsAstUtils.sum(this.resultingExpression, expression2);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
            KtExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            KotlinType type2 = StringTemplateTranslator.this.context().bindingContext().getType(entryExpression);
            if (type2 != null && KotlinBuiltIns.isCharOrNullableChar(type2)) {
                if (type2.isMarkedNullable()) {
                    TemporaryVariable tmp = StringTemplateTranslator.this.context().declareTemporary(translatedExpression, entry);
                    this.append(new JsConditional(JsAstUtils.equality(tmp.assignmentExpression(), new JsNullLiteral()), new JsNullLiteral(), JsAstUtils.charToString(tmp.reference())));
                } else {
                    this.append(JsAstUtils.charToString(translatedExpression));
                }
            } else if (translatedExpression instanceof JsNumberLiteral) {
                this.append(new JsStringLiteral(translatedExpression.toString()));
            } else if (type2 == null || type2.isMarkedNullable()) {
                this.append(TopLevelFIF.TO_STRING.apply((JsExpression)null, new SmartList<JsExpression>(translatedExpression), StringTemplateTranslator.this.context()));
            } else if (this.mustCallToString(type2)) {
                this.append(new JsInvocation((JsExpression)new JsNameRef("toString", translatedExpression), new JsExpression[0]));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull KotlinType type2) {
            Name typeName = DescriptorUtilsKt.getNameIfStandardType(type2);
            if (typeName != null && NamePredicate.STRING.test(typeName)) {
                return false;
            }
            return this.resultingExpression == null;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry) {
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text2) {
            this.append(new JsStringLiteral(text2));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            return this.resultingExpression;
        }
    }
}

