/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.IncrementalModuleEntry;
import org.jetbrains.kotlin.daemon.common.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryJvm;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\bH\u0014J\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J*\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "modulesInfo", "Lorg/jetbrains/kotlin/daemon/common/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/daemon/common/IncrementalModuleInfo;)V", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "Ljava/io/File;", "jar", "getBuildHistoryForDir", "file", "getHistoryForModuleNames", "path", "Ljava/nio/file/Path;", "moduleNames", "", "", "getPossibleModuleNamesForDir", "", "getPossibleModuleNamesFromJar", "", "incremental-compilation-impl"})
public final class ModulesApiHistoryAndroid
extends ModulesApiHistoryJvm {
    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Path jarPath;
        Intrinsics.checkParameterIsNotNull(jar, "jar");
        if (!ModulesApiHistoryKt.access$isParentOf(this.getProjectRootPath(), jar)) {
            return new Either.Error("Non-project jar is modified " + jar);
        }
        Path path2 = jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull(path2, "jarPath");
        return this.getHistoryForModuleNames(path2, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath));
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        if (!ModulesApiHistoryKt.access$isParentOf(this.getProjectRootPath(), file2)) {
            return new Either.Error("Non-project file while looking for history " + file2);
        }
        List moduleNames = CollectionsKt.plus((Collection)this.getPossibleModuleNamesForDir(FilesKt.resolve(file2, "meta-inf")), (Iterable)this.getPossibleModuleNamesForDir(FilesKt.resolve(file2, "META-INF")));
        if (moduleNames.isEmpty()) {
            Either either;
            if (file2.getParentFile() == null) {
                either = new Either.Error("Unable to find history for " + file2);
            } else {
                File file3 = file2.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull(file3, "file.parentFile");
                either = this.getBuildHistoryForDir(file3);
            }
            return either;
        }
        Path path2 = file2.toPath();
        Intrinsics.checkExpressionValueIsNotNull(path2, "file.toPath()");
        return this.getHistoryForModuleNames(path2, moduleNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getPossibleModuleNamesFromJar(Path path2) {
        HashSet<String> result2 = new HashSet<String>();
        try {
            Closeable closeable = new ZipFile(path2.toFile());
            Throwable throwable = null;
            try {
                ZipFile zip2 = (ZipFile)closeable;
                Enumeration<? extends ZipEntry> entries = zip2.entries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry;
                    ZipEntry zipEntry = entry = entries.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull(zipEntry, "entry");
                    String string = name = zipEntry.getName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "name");
                    if (!StringsKt.endsWith(string, ".kotlin_module", true)) continue;
                    result2.add(FilesKt.getNameWithoutExtension(new File(name)));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Throwable t) {
            return CollectionsKt.emptyList();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPossibleModuleNamesForDir(File path2) {
        Object $receiver$iv$iv;
        if (!path2.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        File[] fileArray = path2.listFiles();
        Intrinsics.checkExpressionValueIsNotNull(fileArray, "path.listFiles()");
        Object $receiver$iv = fileArray;
        File[] fileArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (File element$iv$iv : $receiver$iv$iv) {
            void it;
            void v1 = it = element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            String string = v1.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
            if (!StringsKt.endsWith(string, ".kotlin_module", true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            File element$iv$iv;
            Object item$iv$iv = iterator2.next();
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull(v3, "it");
            String string = FilesKt.getNameWithoutExtension((File)v3);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<Set<File>> getHistoryForModuleNames(Path path2, Iterable<String> moduleNames) {
        void $receiver$iv;
        IncrementalModuleEntry it;
        Iterable $receiver$iv$iv;
        void $receiver$iv2;
        Iterable<String> iterable = moduleNames;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv2) {
            String it2 = (String)element$iv;
            Set<IncrementalModuleEntry> set = this.getModulesInfo().getNameToModules().get(it2);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable list$iv = set;
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        HashSet possibleModules = (HashSet)destination$iv;
        Iterable $receiver$iv3 = possibleModules;
        Iterable iterable2 = $receiver$iv3;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IncrementalModuleEntry)element$iv$iv;
            Path path3 = Paths.get(it.getBuildDir().getAbsolutePath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull(path3, "Paths.get(it.buildDir.absolutePath)");
            if (!ModulesApiHistoryKt.access$isParentOf(path3, path2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modules = (List)destination$iv$iv;
        if (modules.isEmpty()) {
            return new Either.Error("Unknown module for " + path2 + " (candidates: " + CollectionsKt.joinToString$default(possibleModules, null, null, null, 0, null, null, 63, null) + ')');
        }
        $receiver$iv$iv = modules;
        Collection destination$iv2 = new HashSet();
        for (Object item$iv : $receiver$iv) {
            it = (IncrementalModuleEntry)item$iv;
            Collection collection = destination$iv2;
            File file2 = it.getBuildHistoryFile();
            collection.add(file2);
        }
        HashSet result2 = (HashSet)destination$iv2;
        return new Either.Success<HashSet>(result2);
    }

    public ModulesApiHistoryAndroid(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkParameterIsNotNull(modulesInfo, "modulesInfo");
        super(modulesInfo);
    }
}

