/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\f\u001a\u00020\bH\u0086\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00032\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "Name", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "nameTransformer", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;Ljava/io/File;)V", "add", "", "sourceFile", "className", "(Ljava/io/File;Ljava/lang/Object;)V", "clearOutputsForSource", "contains", "", "dumpValue", "value", "get", "getFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "path", "kotlin-build-common"})
public abstract class AbstractSourceToOutputMap<Name>
extends BasicStringMap<Collection<? extends String>> {
    private final NameTransformer<Name> nameTransformer;

    public final void clearOutputsForSource(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        String string = sourceFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
        this.remove(string);
    }

    public final void add(@NotNull File sourceFile, Name className2) {
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
        lazyStorage.append(string, this.nameTransformer.asString(className2));
    }

    public final boolean contains(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
        return lazyStorage.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Name> get(@NotNull File sourceFile) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
        Iterable iterable = (Collection)lazyStorage.get(string);
        Collection collection = iterable;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        iterable = collection;
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            Name Name2 = nameTransformer.asName((String)p1);
            collection2.add(Name2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> getFqNames(@NotNull File sourceFile) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
        Iterable iterable = (Collection)lazyStorage.get(string);
        Collection collection = iterable;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        iterable = collection;
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            FqName fqName2 = nameTransformer.asFqName((String)p1);
            collection2.add(fqName2);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    private final void remove(String path2) {
        this.getStorage().remove(path2);
    }

    public AbstractSourceToOutputMap(@NotNull NameTransformer<Name> nameTransformer, @NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull(nameTransformer, "nameTransformer");
        Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
        super(storageFile, PathStringDescriptor.INSTANCE, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        this.nameTransformer = nameTransformer;
    }
}

