/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.Getter;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTrees {
    private final Reference<StubTree> myStub;
    private final Getter<FileElement> myTreeElementPointer;
    final boolean astLoaded;
    final boolean useStrongRefs;

    private FileTrees(@Nullable Reference<StubTree> stub, @Nullable Getter<FileElement> ast, boolean astLoaded, boolean useStrongRefs) {
        this.myStub = stub;
        this.myTreeElementPointer = ast;
        this.astLoaded = astLoaded;
        this.useStrongRefs = useStrongRefs;
    }

    @Nullable
    StubTree derefStub() {
        return SoftReference.dereference(this.myStub);
    }

    @Nullable
    FileElement derefTreeElement() {
        return SoftReference.deref(this.myTreeElementPointer);
    }

    FileTrees switchToStrongRefs() {
        return new FileTrees(this.myStub, this.myTreeElementPointer, this.astLoaded, true);
    }

    FileTrees clearStub(@NotNull String reason) {
        StubTree stubHolder;
        if (reason == null) {
            FileTrees.$$$reportNull$$$0(0);
        }
        if ((stubHolder = this.derefStub()) != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        return new FileTrees(null, this.myTreeElementPointer, this.astLoaded, this.useStrongRefs);
    }

    FileTrees withAst(@NotNull Getter<FileElement> ast) {
        if (ast == null) {
            FileTrees.$$$reportNull$$$0(1);
        }
        return new FileTrees(this.myStub, ast, true, this.useStrongRefs);
    }

    FileTrees withExclusiveStub(@NotNull StubTree stub, Set<PsiFileImpl> allRoots) {
        if (stub == null) {
            FileTrees.$$$reportNull$$$0(2);
        }
        if (this.derefTreeElement() != null || this.useStrongRefs) {
            throw new RuntimeException(this.toString() + "; roots=" + allRoots + "; root trees=" + ContainerUtil.map(allRoots, PsiFileImpl::getFileTrees));
        }
        return new FileTrees(new SoftReference<StubTree>(stub), null, false, false);
    }

    FileTrees withGreenStub(@NotNull StubTree stub, @NotNull PsiFileImpl file2) {
        if (stub == null) {
            FileTrees.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileTrees.$$$reportNull$$$0(4);
        }
        if (this.derefTreeElement() == null || !this.astLoaded) {
            throw new RuntimeException("No AST in file " + file2 + " of " + file2.getClass() + "; " + this);
        }
        return new FileTrees(new SoftReference<StubTree>(stub), this.myTreeElementPointer, true, this.useStrongRefs);
    }

    static FileTrees noStub(@Nullable FileElement ast, @NotNull PsiFileImpl file2) {
        if (file2 == null) {
            FileTrees.$$$reportNull$$$0(5);
        }
        return new FileTrees(null, ast, ast != null, file2 instanceof DummyHolder);
    }

    public String toString() {
        return "FileTrees{stub=" + (this.myStub == null ? "noRef" : this.derefStub()) + ", AST=" + (this.myTreeElementPointer == null ? "noRef" : this.derefTreeElement()) + ", astLoaded=" + this.astLoaded + ", useStrongRefs=" + this.useStrongRefs + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/FileTrees";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "clearStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withAst";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withExclusiveStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withGreenStub";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "noStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

