/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\r\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "serializeClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeEnumEntry", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$EnumEntry$Builder;", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializePackage", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "serializeType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "serializeTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;", "serializeValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter$Builder;", "serialization"})
public class KotlinSerializerExtensionBase
extends SerializerExtension {
    @NotNull
    private final StringTableImpl stringTable;
    private final SerializerExtensionProtocol protocol;

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getClassAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        proto.setExtension(this.protocol.getPackageFqName(), this.getStringTable().getPackageFqNameIndex(packageFqName));
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getConstructorAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getFunctionAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getPropertyAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
        ConstantValue<?> constantValue = descriptor2.getCompileTimeInitializer();
        if (constantValue == null) {
            return;
        }
        ConstantValue<?> constantInitializer = constantValue;
        if (!(constantInitializer instanceof NullValue)) {
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, ProtoBuf.Annotation.Argument.Value> generatedExtension = this.protocol.getCompileTimeValue();
            AnnotationSerializer annotationSerializer2 = this.getAnnotationSerializer();
            ConstantValue<?> constantValue2 = constantInitializer;
            Intrinsics.checkExpressionValueIsNotNull(constantValue2, "constantInitializer");
            proto.setExtension(generatedExtension, annotationSerializer2.valueProto(constantValue2).build());
        }
    }

    @Override
    public void serializeEnumEntry(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getEnumEntryAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            proto.addExtension(this.protocol.getParameterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(type2)) {
            proto.addExtension(this.protocol.getTypeAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(typeParameter)) {
            proto.addExtension(this.protocol.getTypeParameterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    public KotlinSerializerExtensionBase(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkParameterIsNotNull(protocol, "protocol");
        this.protocol = protocol;
        this.stringTable = new StringTableImpl();
    }
}

