/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CoroutineExceptionHandlerKt;
import kotlinx.coroutines.experimental.JobSupport;
import kotlinx.coroutines.experimental.ResumeModeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0001J\u001d\u0010\u0010\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0015\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlinx/coroutines/experimental/AbstractContinuation;", "T", "Lkotlinx/coroutines/experimental/JobSupport;", "Lkotlin/coroutines/experimental/Continuation;", "delegate", "resumeMode", "", "(Lkotlin/coroutines/experimental/Continuation;I)V", "_decision", "Lkotlinx/atomicfu/AtomicInt;", "afterCompletion", "", "state", "", "mode", "getResult", "getSuccessfulResult", "(Ljava/lang/Object;)Ljava/lang/Object;", "handleException", "exception", "", "resume", "value", "(Ljava/lang/Object;)V", "resumeImpl", "proposedUpdate", "resumeWithException", "tryResume", "", "trySuspend", "kotlinx-coroutines-core"})
public abstract class AbstractContinuation<T>
extends JobSupport
implements Continuation<T> {
    private volatile int _decision;
    private static final AtomicIntegerFieldUpdater _decision$FU = AtomicIntegerFieldUpdater.newUpdater(AbstractContinuation.class, "_decision");
    @JvmField
    @NotNull
    protected final Continuation<T> delegate;
    @JvmField
    protected final int resumeMode;

    private final boolean trySuspend() {
        AbstractContinuation $receiver$iv = this;
        block4: while (true) {
            int decision = $receiver$iv._decision;
            switch (decision) {
                case 0: {
                    if (!_decision$FU.compareAndSet(this, 0, 1)) continue block4;
                    return true;
                }
                case 2: {
                    return false;
                }
                default: {
                    String string = "Already suspended";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            break;
        }
    }

    private final boolean tryResume() {
        AbstractContinuation $receiver$iv = this;
        block4: while (true) {
            int decision = $receiver$iv._decision;
            switch (decision) {
                case 0: {
                    if (!_decision$FU.compareAndSet(this, 0, 2)) continue block4;
                    return true;
                }
                case 1: {
                    return false;
                }
                default: {
                    String string = "Already resumed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            break;
        }
    }

    @PublishedApi
    @Nullable
    public final Object getResult() {
        if (this.trySuspend()) {
            return IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        Object state2 = this.getState();
        if (state2 instanceof JobSupport.CompletedExceptionally) {
            throw ((JobSupport.CompletedExceptionally)state2).getException();
        }
        return this.getSuccessfulResult(state2);
    }

    @Override
    protected void afterCompletion(@Nullable Object state2, int mode) {
        if (this.tryResume()) {
            return;
        }
        if (state2 instanceof JobSupport.CompletedExceptionally) {
            ResumeModeKt.resumeWithExceptionMode(this.delegate, ((JobSupport.CompletedExceptionally)state2).getException(), mode);
        } else {
            ResumeModeKt.resumeMode(this.delegate, this.getSuccessfulResult(state2), mode);
        }
    }

    protected <T> T getSuccessfulResult(@Nullable Object state2) {
        return (T)state2;
    }

    @Override
    public void resume(T value) {
        this.resumeImpl(value, this.resumeMode);
    }

    @Override
    public void resumeWithException(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        this.resumeImpl(new JobSupport.CompletedExceptionally(exception), this.resumeMode);
    }

    protected final void resumeImpl(@Nullable Object proposedUpdate, int resumeMode) {
        Object state2;
        Object object;
        AbstractContinuation this_$iv = this;
        while ((object = (state2 = JobSupport.access$getState$p(this_$iv))) instanceof JobSupport.Incomplete) {
            if (!this.updateState$kotlinx_coroutines_core((JobSupport.Incomplete)state2, proposedUpdate, resumeMode)) continue;
            return;
        }
        if (object instanceof JobSupport.Cancelled) {
            if (proposedUpdate instanceof JobSupport.CompletedExceptionally && Intrinsics.areEqual(((JobSupport.CompletedExceptionally)proposedUpdate).getException(), ((JobSupport.Cancelled)state2).getException()) ^ true) {
                this.handleException(((JobSupport.CompletedExceptionally)proposedUpdate).getException());
            }
            return;
        }
        String string = "Already resumed, but got " + proposedUpdate;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    protected void handleException(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        CoroutineExceptionHandlerKt.handleCoroutineException(this.getContext(), exception);
    }

    public AbstractContinuation(@NotNull Continuation<? super T> delegate2, int resumeMode) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        super(true);
        this.delegate = delegate2;
        this.resumeMode = resumeMode;
        this._decision = 0;
    }
}

