/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLoweringKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend"})
public final class StaticDefaultFunctionLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        irClass.accept(this, null);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        if (Intrinsics.areEqual(declaration.getOrigin(), DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) && declaration.getDispatchReceiverParameter() != null) {
            DeclarationDescriptor declarationDescriptor = declaration.getDescriptor().getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor = (ClassDescriptor)declarationDescriptor;
            Name name = declaration.getDescriptor().getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "declaration.descriptor.name");
            FunctionDescriptor functionDescriptor = declaration.getDescriptor();
            ReceiverParameterDescriptor receiverParameterDescriptor = declaration.getDescriptor().getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "declaration.descriptor.dispatchReceiverParameter!!");
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "declaration.descriptor.d\u2026hReceiverParameter!!.type");
            SimpleFunctionDescriptorImpl newFunction = InterfaceLoweringKt.createStaticFunctionWithReceivers(classOrPackageFragmentDescriptor, name, functionDescriptor, kotlinType);
            FunctionDescriptor functionDescriptor2 = newFunction;
            Visibility visibility = Visibilities.PUBLIC;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
            irStatement = InterfaceLoweringKt.createFunctionAndMapVariables(functionDescriptor2, declaration, visibility);
        } else {
            irStatement = super.visitFunction(declaration);
        }
        return irStatement;
    }

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    public StaticDefaultFunctionLowering(@NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull(state2, "state");
        this.state = state2;
    }
}

