/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.FileSystem$WhenMappings;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "daemon-common"})
public final class FileSystem {
    public static final FileSystem INSTANCE;

    @NotNull
    public final String getUserHomePath() {
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"user.home\")");
        return string;
    }

    @NotNull
    public final String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"java.io.tmpdir\")");
        return string;
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getRuntimeStateFilesPath(String ... names2) {
        String string;
        Object dir;
        Object object;
        String p2;
        Object p1;
        String element$iv;
        Object accumulator$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull(names2, "names");
        boolean bl = ArraysKt.any(names2);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            $receiver$iv = names2;
            accumulator$iv = base;
            int n = ((String[])$receiver$iv).length;
            for (int i = 0; i < n; ++i) {
                String string3 = element$iv = $receiver$iv[i];
                p1 = accumulator$iv;
                accumulator$iv = new File((File)p1, p2);
            }
            object = accumulator$iv;
        } else {
            File initial$iv;
            String string4;
            $receiver$iv = ArraysKt.drop(names2, 1);
            accumulator$iv = ArraysKt.first(names2);
            String string5 = this.getUserHomePath();
            String it = (String)accumulator$iv;
            String string6 = string4 = StringsKt.startsWith$default(it, ".", false, 2, null) ? it : '.' + it;
            String string7 = string5;
            File accumulator$iv2 = initial$iv = new File(string7, string6);
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                p2 = element$iv = iterator2.next();
                p1 = accumulator$iv2;
                accumulator$iv2 = new File((File)p1, p2);
            }
            object = dir = accumulator$iv2;
        }
        if (((File)dir).exists() && ((File)dir).isDirectory() || ((File)dir).mkdirs()) {
            String string8 = ((File)dir).getAbsolutePath();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull(string8, "dir.absolutePath");
        } else {
            string = this.getTempPath();
        }
        return string;
    }

    private FileSystem() {
    }

    static {
        FileSystem fileSystem;
        INSTANCE = fileSystem = new FileSystem();
    }
}

