/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, proto.getId()));
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.valueParameters");
                Iterable $receiver$iv = list;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                Iterable iterable = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    Name name = v2.getName();
                    map2.put(name, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.argumentList");
                Iterable capacity$iv22 = $receiver$iv = (Iterable)list2;
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    ProtoBuf.Annotation.Argument it;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    ProtoBuf.Annotation.Argument argument = it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)argument, (String)"it");
                    if (this.resolveArgument(argument, parameterByName, nameResolver) == null) continue;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(NameResolverUtilKt.getName(nameResolver, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"proto.value");
        return new Pair((Object)name, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        isUnsigned = Flags.IS_UNSIGNED.get(value.getFlags());
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                var7_5 = (byte)value.getIntValue();
                var6_10 = this;
                v1 = isUnsigned;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"isUnsigned");
                predicate$iv = v1;
                if (predicate$iv) {
                    p1 = $receiver$iv;
                    v2 /* !! */  = new UByteValue((byte)p1);
                } else {
                    p1 = $receiver$iv;
                    v2 /* !! */  = new ByteValue((byte)p1);
                }
                v3 = v2 /* !! */ ;
                break;
            }
            case 2: {
                v3 = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                $receiver$iv = (short)value.getIntValue();
                this_$iv = this;
                v4 = isUnsigned;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"isUnsigned");
                predicate$iv = v4;
                if (predicate$iv) {
                    p1 = $receiver$iv;
                    v5 /* !! */  = new UShortValue(p1);
                } else {
                    p1 = $receiver$iv;
                    v5 /* !! */  = new ShortValue(p1);
                }
                v3 = v5 /* !! */ ;
                break;
            }
            case 4: {
                $receiver$iv = (int)value.getIntValue();
                this_$iv = this;
                v6 = isUnsigned;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"isUnsigned");
                predicate$iv = v6;
                if (predicate$iv) {
                    p1 = $receiver$iv;
                    v7 /* !! */  = new UIntValue(p1);
                } else {
                    p1 = $receiver$iv;
                    v7 /* !! */  = new IntValue(p1);
                }
                v3 = v7 /* !! */ ;
                break;
            }
            case 5: {
                $receiver$iv = value.getIntValue();
                this_$iv = this;
                v8 = isUnsigned;
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"isUnsigned");
                predicate$iv = v8;
                if (predicate$iv) {
                    p1 = $receiver$iv;
                    v9 /* !! */  = new ULongValue(p1);
                } else {
                    p1 = $receiver$iv;
                    v9 /* !! */  = new LongValue(p1);
                }
                v3 = v9 /* !! */ ;
                break;
            }
            case 6: {
                v3 = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v3 = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v3 = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v3 = new StringValue(nameResolver.getString(value.getStringValue()));
                break;
            }
            case 10: {
                v3 = this.resolveClassLiteralValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()));
                break;
            }
            case 11: {
                v3 = new EnumValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), NameResolverUtilKt.getName(nameResolver, value.getEnumValueId()));
                break;
            }
            case 12: {
                v10 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"value.annotation");
                v3 = new AnnotationValue(this.deserializeAnnotation(v10, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                v11 = arrayElements = value.getArrayElementList();
                Intrinsics.checkExpressionValueIsNotNull(v11, (String)"arrayElements");
                p1 = v11;
                if (p1.isEmpty() == false) {
                    v12 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"arrayElements.first()");
                    actualElementType = this.resolveArrayElementType((ProtoBuf.Annotation.Argument.Value)v12, nameResolver);
                    v13 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v13 != null) {
                        v14 = v13;
                    } else {
                        v15 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                        v14 = v15;
                    }
                } else if (expectedIsArray) {
                    v14 = expectedType;
                } else {
                    v16 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"builtIns.getArrayType(Va\u2026ARIANT, builtIns.anyType)");
                    v14 = v16;
                }
                actualArrayType = v14;
                expectedElementType = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                $i$a$6$unknown = arrayElements;
                var20_31 = ConstantValueFactory.INSTANCE;
                $i$a$8$unknown = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var16_36 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var21_37 = destination$iv$iv;
                    v17 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"expectedElementType");
                    v18 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"it");
                    var22_38 = this.resolveValue(v17, (ProtoBuf.Annotation.Argument.Value)v18, nameResolver);
                    var21_37.add(var22_38);
                }
                var21_37 = (List)destination$iv$iv;
                v3 = var20_31.createArrayValue((List<? extends ConstantValue<?>>)var21_37, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var6_15 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                throw (Throwable)new IllegalStateException(var6_15.toString());
            }
        }
        result = v3;
        return TypeUtilsKt.isSubtypeOf(result.getType(this.module), expectedType) != false ? result : (ConstantValue)ErrorValue.Companion.create("Unexpected argument value");
    }

    private final ConstantValue<?> resolveClassLiteralValue(ClassId classId) {
        SimpleType simpleType2 = this.resolveClass(classId).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"resolveClass(classId).defaultType");
        KotlinType starProjectedType = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
        ClassId classId2 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.kClass.toSafe());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"ClassId.topLevel(KotlinB\u2026FQ_NAMES.kClass.toSafe())");
        ClassDescriptor kClass = this.resolveClass(classId2);
        SimpleType type2 = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), kClass, CollectionsKt.listOf((Object)new TypeProjectionImpl(starProjectedType)));
        return new KClassValue(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns;
        KotlinBuiltIns $receiver = kotlinBuiltIns = this.getBuiltIns();
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    SimpleType simpleType2 = $receiver.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"byteType");
                    return simpleType3;
                }
                case 2: {
                    SimpleType simpleType4 = $receiver.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"charType");
                    return simpleType3;
                }
                case 3: {
                    SimpleType simpleType5 = $receiver.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"shortType");
                    return simpleType3;
                }
                case 4: {
                    SimpleType simpleType6 = $receiver.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"intType");
                    return simpleType3;
                }
                case 5: {
                    SimpleType simpleType7 = $receiver.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType7, (String)"longType");
                    return simpleType3;
                }
                case 6: {
                    SimpleType simpleType8 = $receiver.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType8, (String)"floatType");
                    return simpleType3;
                }
                case 7: {
                    SimpleType simpleType9 = $receiver.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType9, (String)"doubleType");
                    return simpleType3;
                }
                case 8: {
                    SimpleType simpleType10 = $receiver.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType10, (String)"booleanType");
                    return simpleType3;
                }
                case 9: {
                    SimpleType simpleType11 = $receiver.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType11, (String)"stringType");
                    return simpleType3;
                }
                case 10: {
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 11: {
                    SimpleType simpleType12 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, value.getClassId())).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType12, (String)"resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ProtoBuf.Annotation annotation = value.getAnnotation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"value.annotation");
                    SimpleType simpleType13 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, annotation.getId())).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType13, (String)"resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        String string = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }
}

