/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.AbstractContinuation;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CompletedIdempotentResult;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.DebugKt;
import kotlinx.coroutines.experimental.DispatchedContinuation;
import kotlinx.coroutines.experimental.Job;
import kotlinx.coroutines.experimental.JobSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001d\u0010\u0012\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0015\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J!\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010\u001f\u001a\u00020\u000f*\u00020 2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u00020\u000f*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lkotlinx/coroutines/experimental/CancellableContinuationImpl;", "T", "Lkotlinx/coroutines/experimental/AbstractContinuation;", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "delegate", "Lkotlin/coroutines/experimental/Continuation;", "resumeMode", "", "(Lkotlin/coroutines/experimental/Continuation;I)V", "_context", "Lkotlin/coroutines/experimental/CoroutineContext;", "context", "getContext", "()Lkotlin/coroutines/experimental/CoroutineContext;", "completeResume", "", "token", "", "getSuccessfulResult", "state", "(Ljava/lang/Object;)Ljava/lang/Object;", "initCancellability", "nameString", "", "tryResume", "value", "idempotent", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "tryResumeWithException", "exception", "", "resumeUndispatched", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "(Lkotlinx/coroutines/experimental/CoroutineDispatcher;Ljava/lang/Object;)V", "resumeUndispatchedWithException", "kotlinx-coroutines-core"})
@PublishedApi
public final class CancellableContinuationImpl<T>
extends AbstractContinuation<T>
implements CancellableContinuation<T> {
    private volatile CoroutineContext _context;

    @Override
    @NotNull
    public CoroutineContext getContext() {
        CoroutineContext coroutineContext = this._context;
        if (coroutineContext == null) {
            CoroutineContext coroutineContext2;
            CoroutineContext it;
            this._context = it = (coroutineContext2 = this.delegate.getContext().plus(this));
            coroutineContext = coroutineContext2;
        }
        return coroutineContext;
    }

    @Override
    public void initCancellability() {
        this.initParentJob((Job)this.delegate.getContext().get(Job.Key));
    }

    @Override
    @Nullable
    public Object tryResume(T value, @Nullable Object idempotent) {
        Object state2;
        Object object;
        while ((object = (state2 = this.getState())) instanceof JobSupport.Incomplete) {
            Object update = idempotent == null ? value : new CompletedIdempotentResult(idempotent, value, (JobSupport.Incomplete)state2);
            if (!this.tryUpdateState$kotlinx_coroutines_core((JobSupport.Incomplete)state2, update)) continue;
            return state2;
        }
        if (object instanceof CompletedIdempotentResult) {
            if (((CompletedIdempotentResult)state2).idempotentResume == idempotent) {
                boolean bl;
                boolean bl2 = bl = ((CompletedIdempotentResult)state2).result == value;
                if (!bl) {
                    String string = "Non-idempotent resume";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return ((CompletedIdempotentResult)state2).token;
            }
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object tryResumeWithException(@NotNull Throwable exception) {
        Object state2;
        Object object;
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        while ((object = (state2 = this.getState())) instanceof JobSupport.Incomplete) {
            if (!this.tryUpdateState$kotlinx_coroutines_core((JobSupport.Incomplete)state2, new JobSupport.CompletedExceptionally(exception))) continue;
            return state2;
        }
        return null;
    }

    @Override
    public void completeResume(@NotNull Object token) {
        Intrinsics.checkParameterIsNotNull(token, "token");
        this.completeUpdateState$kotlinx_coroutines_core((JobSupport.Incomplete)token, this.getState(), this.resumeMode);
    }

    @Override
    public void resumeUndispatched(@NotNull CoroutineDispatcher $receiver, T value) {
        DispatchedContinuation dc;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Continuation continuation2 = this.delegate;
        if (!(continuation2 instanceof DispatchedContinuation)) {
            continuation2 = null;
        }
        DispatchedContinuation dispatchedContinuation = dc = (DispatchedContinuation)continuation2;
        this.resumeImpl(value, (dispatchedContinuation != null ? dispatchedContinuation.dispatcher : null) == $receiver ? 3 : this.resumeMode);
    }

    @Override
    public void resumeUndispatchedWithException(@NotNull CoroutineDispatcher $receiver, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Continuation continuation2 = this.delegate;
        if (!(continuation2 instanceof DispatchedContinuation)) {
            continuation2 = null;
        }
        DispatchedContinuation dc = (DispatchedContinuation)continuation2;
        DispatchedContinuation dispatchedContinuation = dc;
        this.resumeImpl(new JobSupport.CompletedExceptionally(exception), (dispatchedContinuation != null ? dispatchedContinuation.dispatcher : null) == $receiver ? 3 : this.resumeMode);
    }

    @Override
    protected <T> T getSuccessfulResult(@Nullable Object state2) {
        return (T)(state2 instanceof CompletedIdempotentResult ? ((CompletedIdempotentResult)state2).result : state2);
    }

    @Override
    @NotNull
    protected String nameString() {
        return "CancellableContinuation(" + DebugKt.toDebugString(this.delegate) + ')';
    }

    public CancellableContinuationImpl(@NotNull Continuation<? super T> delegate, int resumeMode) {
        Intrinsics.checkParameterIsNotNull(delegate, "delegate");
        super(delegate, resumeMode);
    }
}

