/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UsedImportsCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "()V", "usedImports", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getUsedImports", "()Ljava/util/Set;", "visitFunction", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "js.translator"})
final class UsedImportsCollector
extends RecursiveJsVisitor {
    @NotNull
    private final Set<JsName> usedImports;

    @NotNull
    public final Set<JsName> getUsedImports() {
        return this.usedImports;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
        JsName name = nameRef.getName();
        if (name != null && MetadataProperties.getImported(name)) {
            Collection collection = this.usedImports;
            collection.add(name);
        }
        super.visitNameRef(nameRef);
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(x);
        if (coroutineMetadata != null) {
            CoroutineMetadata coroutineMetadata2;
            CoroutineMetadata $receiver = coroutineMetadata2 = coroutineMetadata;
            this.accept((JsNode)$receiver.getSuspendObjectRef());
            this.accept((JsNode)$receiver.getBaseClassRef());
        }
        super.visitFunction(x);
    }

    public UsedImportsCollector() {
        Set set;
        UsedImportsCollector usedImportsCollector = this;
        usedImportsCollector.usedImports = set = (Set)new LinkedHashSet();
    }
}

