/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import gnu.trove.TIntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "psi"})
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    private int[] sourceOffsets;

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkParameterIsNotNull(rangeInsideHost, "rangeInsideHost");
        Intrinsics.checkParameterIsNotNull(outChars, "outChars");
        TIntArrayList sourceOffsetsList = new TIntArrayList();
        int sourceOffset = 0;
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkExpressionValueIsNotNull(psiLanguageInjectionHost, "myHost");
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)psiLanguageInjectionHost).getEntries();
        int n = ktStringTemplateEntryArray.length;
        for (int i = 0; i < n; ++i) {
            int it;
            int n2;
            int n3;
            int n4;
            KtStringTemplateEntry child;
            KtStringTemplateEntry ktStringTemplateEntry = child = ktStringTemplateEntryArray[i];
            Intrinsics.checkExpressionValueIsNotNull(ktStringTemplateEntry, "child");
            TextRange childRange = TextRange.from(ktStringTemplateEntry.getStartOffsetInParent(), child.getTextLength());
            int n5 = rangeInsideHost.getEndOffset();
            TextRange textRange = childRange;
            Intrinsics.checkExpressionValueIsNotNull(textRange, "childRange");
            if (n5 <= textRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            KtStringTemplateEntry ktStringTemplateEntry2 = child;
            if (ktStringTemplateEntry2 instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                n4 = unescaped.length();
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    it = n3++;
                    sourceOffsetsList.add(sourceOffset);
                }
                sourceOffset += child.getTextLength();
                continue;
            }
            TextRange textRange2 = rangeInsideHost.intersection(childRange);
            if (textRange2 == null) {
                Intrinsics.throwNpe();
            }
            TextRange textRange3 = textRange2.shiftRight(-childRange.getStartOffset());
            CharSequence charSequence = child.getText();
            TextRange textRange4 = textRange3;
            Intrinsics.checkExpressionValueIsNotNull(textRange4, "textRange");
            outChars.append(charSequence, textRange4.getStartOffset(), textRange3.getEndOffset());
            n4 = textRange3.getLength();
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                it = n3++;
                int n6 = sourceOffset;
                sourceOffset = n6 + 1;
                sourceOffsetsList.add(n6);
            }
        }
        sourceOffsetsList.add(sourceOffset);
        this.sourceOffsets = sourceOffsetsList.toNativeArray();
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkParameterIsNotNull(rangeInsideHost, "rangeInsideHost");
        int[] offsets = this.sourceOffsets;
        if (offsets == null || offsetInDecoded >= offsets.length) {
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkExpressionValueIsNotNull(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.getContentRange((KtStringTemplateExpression)psiLanguageInjectionHost);
    }

    @Override
    public boolean isOneLine() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkExpressionValueIsNotNull(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)psiLanguageInjectionHost);
    }

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkParameterIsNotNull(host, "host");
        super((PsiLanguageInjectionHost)host);
    }
}

