/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

public class KtObjectElementType
extends KtStubElementType<KotlinObjectStub, KtObjectDeclaration> {
    public KtObjectElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtObjectDeclaration.class, KotlinObjectStub.class);
    }

    @Override
    public KotlinObjectStub createStub(@NotNull KtObjectDeclaration psi, StubElement parentStub) {
        String name = psi.getName();
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        return new KotlinObjectStubImpl(parentStub, StringRef.fromString(name), fqName2, Utils.INSTANCE.wrapStrings(superNames), psi.isTopLevel(), psi.isCompanion(), psi.isLocal(), psi.isObjectLiteral());
    }

    @Override
    public void serialize(@NotNull KotlinObjectStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub2.getName());
        FqName fqName2 = stub2.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.toString() : null);
        dataStream.writeBoolean(stub2.isTopLevel());
        dataStream.writeBoolean(stub2.isCompanion());
        dataStream.writeBoolean(stub2.isLocal());
        dataStream.writeBoolean(stub2.isObjectLiteral());
        List<String> superNames = stub2.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name : superNames) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public KotlinObjectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        StringRef fqNameStr = dataStream.readName();
        FqName fqName2 = fqNameStr != null ? new FqName(fqNameStr.toString()) : null;
        boolean isTopLevel = dataStream.readBoolean();
        boolean isCompanion = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isObjectLiteral = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        return new KotlinObjectStubImpl(parentStub, name, fqName2, superNames, isTopLevel, isCompanion, isLocal, isObjectLiteral);
    }

    @Override
    public void indexStub(@NotNull KotlinObjectStub stub2, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexObject(stub2, sink);
    }
}

