/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.type;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.type.MapPsiToAsmDesc;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/type/MapPsiToAsmDesc;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "classDesc", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "error", "message", "methodDesc", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "primitive", "kotlin.jvm.PlatformType", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "typeDesc", "type", "Lcom/intellij/psi/PsiType;", "unknownSignature", "util"})
public final class MapPsiToAsmDesc {
    private static final Logger LOG;
    public static final MapPsiToAsmDesc INSTANCE;

    @NotNull
    public final String typeDesc(@NotNull PsiType type2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        PsiType psiType = type2;
        if (Intrinsics.areEqual(psiType, PsiType.VOID)) {
            Type type3 = Type.VOID_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type3, "VOID_TYPE");
            String string = this.primitive(type3);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(VOID_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.BOOLEAN)) {
            Type type4 = Type.BOOLEAN_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type4, "BOOLEAN_TYPE");
            String string = this.primitive(type4);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(BOOLEAN_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.CHAR)) {
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type5, "CHAR_TYPE");
            String string = this.primitive(type5);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(CHAR_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.INT)) {
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type6, "INT_TYPE");
            String string = this.primitive(type6);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(INT_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.BYTE)) {
            Type type7 = Type.BYTE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type7, "BYTE_TYPE");
            String string = this.primitive(type7);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(BYTE_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.SHORT)) {
            Type type8 = Type.SHORT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type8, "SHORT_TYPE");
            String string = this.primitive(type8);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(SHORT_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.LONG)) {
            Type type9 = Type.LONG_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type9, "LONG_TYPE");
            String string = this.primitive(type9);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(LONG_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.FLOAT)) {
            Type type10 = Type.FLOAT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type10, "FLOAT_TYPE");
            String string = this.primitive(type10);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(FLOAT_TYPE)");
        } else if (Intrinsics.areEqual(psiType, PsiType.DOUBLE)) {
            Type type11 = Type.DOUBLE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type11, "DOUBLE_TYPE");
            String string = this.primitive(type11);
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "primitive(DOUBLE_TYPE)");
        } else if (psiType instanceof PsiArrayType) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            PsiType psiType2 = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(psiType2, "type.componentType");
            object = stringBuilder.append(this.typeDesc(psiType2)).toString();
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            PsiClass psiClass = resolved;
            if (psiClass instanceof PsiTypeParameter) {
                Object object2;
                Object it;
                PsiClassType[] psiClassTypeArray = ((PsiTypeParameter)resolved).getSuperTypes();
                Intrinsics.checkExpressionValueIsNotNull(psiClassTypeArray, "resolved.superTypes");
                object = ArraysKt.firstOrNull(psiClassTypeArray);
                if (object == null || (object = INSTANCE.typeDesc((PsiType)(it = (object2 = object)))) == null) {
                    object = "Ljava/lang/Object;";
                }
            } else {
                object = psiClass instanceof PsiClass ? this.classDesc(resolved) : (psiClass == null ? this.unknownSignature() : this.error("Resolved to unexpected " + resolved + " of class " + resolved.getClass()));
            }
        } else {
            object = this.error("Unexpected type " + type2 + " of class " + type2.getClass());
        }
        return object;
    }

    private final String classDesc(PsiClass psiClass) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("L");
        List classes2 = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.generateSequence(psiClass, (Function1)classDesc.1.classes.1.INSTANCE)));
        String string = ((PsiClass)CollectionsKt.first(classes2)).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(string, "classes.first().qualifiedName!!");
        $receiver.append(StringsKt.replace$default(string, ".", "/", false, 4, null));
        Iterable $receiver$iv = CollectionsKt.drop(classes2, 1);
        for (Object element$iv : $receiver$iv) {
            PsiClass it = (PsiClass)element$iv;
            $receiver.append("$");
            String string2 = it.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            $receiver.append(string2);
        }
        $receiver.append(";");
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    @NotNull
    public final String methodDesc(@NotNull PsiMethod psiMethod) {
        StringBuilder stringBuilder;
        block4: {
            block3: {
                PsiType psiType;
                PsiType it;
                Intrinsics.checkParameterIsNotNull(psiMethod, "psiMethod");
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                $receiver.append("(");
                PsiParameterList psiParameterList = psiMethod.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull(psiParameterList, "psiMethod.parameterList");
                PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(psiParameterArray, "psiMethod.parameterList.parameters");
                PsiParameter[] $receiver$iv = psiParameterArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiParameter element$iv;
                    PsiParameter it2;
                    PsiParameter psiParameter = it2 = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull(psiParameter, "it");
                    PsiType psiType2 = psiParameter.getType();
                    Intrinsics.checkExpressionValueIsNotNull(psiType2, "it.type");
                    $receiver.append(INSTANCE.typeDesc(psiType2));
                }
                $receiver.append(")");
                Object object = psiMethod.getReturnType();
                if (object == null) break block3;
                PsiType psiType3 = it = (psiType = object);
                Intrinsics.checkExpressionValueIsNotNull(psiType3, "it");
                object = $receiver.append(INSTANCE.typeDesc(psiType3));
                if (object != null) break block4;
            }
            return INSTANCE.unknownSignature();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String unknownSignature() {
        return "";
    }

    private final String error(String message) {
        LOG.error(message);
        return this.unknownSignature();
    }

    private final String primitive(Type asmType) {
        return asmType.getDescriptor();
    }

    private MapPsiToAsmDesc() {
    }

    static {
        MapPsiToAsmDesc mapPsiToAsmDesc;
        INSTANCE = mapPsiToAsmDesc = new MapPsiToAsmDesc();
        LOG = Logger.getInstance(mapPsiToAsmDesc.getClass());
    }
}

