/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.CleanBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.TaintedBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J \u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016J \u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J \u0010!\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J \u0010&\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0013H\u0014J\u001a\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010)\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "checkUsedValue", "", "value", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "createNewBoxing", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "isExactValue", "", "merge", "v", "w", "naryOperation", "values", "", "onAreEqual", "value1", "value2", "onCompareTo", "onMergeFail", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "markBoxedArgumentValues", "backend"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    private final InsnList insnList;
    private final GenerationState generationState;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Map map2 = this.boxingPlaces;
        Integer key$iv = this.insnList.indexOf(insn);
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            CleanBoxedValue boxedBasicValue = new CleanBoxedValue(type2, insn, progressionIterator, this.generationState);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    protected final void checkUsedValue(@NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof TaintedBoxedValue) {
            this.onMergeFail((BoxedBasicValue)value);
        }
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        Value value;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(values, "values");
        Iterable $receiver$iv = values;
        for (Object element$iv : $receiver$iv) {
            BasicValue it = (BasicValue)element$iv;
            this.checkUsedValue(it);
        }
        Value value2 = super.naryOperation(insn, (List)values);
        BasicValue basicValue = CollectionsKt.firstOrNull(values);
        if (basicValue == null) {
            return value2;
        }
        BasicValue firstArg = basicValue;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            this.markBoxedArgumentValues(values);
            Value value3 = value2;
            Intrinsics.checkExpressionValueIsNotNull(value3, "value");
            Type type2 = ((BasicValue)value3).getType();
            Intrinsics.checkExpressionValueIsNotNull(type2, "value.type");
            value = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn, this.generationState) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Value value4 = value2;
            Intrinsics.checkExpressionValueIsNotNull(value4, "value");
            Type type3 = ((BasicValue)value4).getType();
            Intrinsics.checkExpressionValueIsNotNull(type3, "value.type");
            this.onUnboxing(insn, boxedBasicValue, type3);
            value = value2;
        } else if (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values)) {
            value = ProgressionIteratorBasicValue.byProgressionClassType(firstArg.getType());
        } else if (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values)) {
            BasicValue basicValue2 = firstArg;
            if (!(basicValue2 instanceof ProgressionIteratorBasicValue)) {
                basicValue2 = null;
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue = (ProgressionIteratorBasicValue)basicValue2;
            if (progressionIteratorBasicValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)"firstArg should be progression iterator"));
            }
            ProgressionIteratorBasicValue progressionIterator = progressionIteratorBasicValue;
            Type type4 = AsmUtil.boxType(progressionIterator.getValuesPrimitiveType());
            Intrinsics.checkExpressionValueIsNotNull(type4, "AsmUtil.boxType(progress\u2026ator.valuesPrimitiveType)");
            value = this.createNewBoxing(insn, type4, progressionIterator);
        } else if (BoxingInterpreterKt.isAreEqualIntrinsicForSameTypedBoxedValues(insn, values) && BoxingInterpreterKt.canValuesBeUnboxedForAreEqual(values, this.generationState)) {
            BasicValue basicValue3 = values.get(0);
            if (basicValue3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue4 = values.get(1);
            if (basicValue4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onAreEqual(insn, (BoxedBasicValue)basicValue3, (BoxedBasicValue)basicValue4);
            value = value2;
        } else if (BoxingInterpreterKt.isJavaLangComparableCompareToForSameTypedBoxedValues(insn, values)) {
            BasicValue basicValue5 = values.get(0);
            if (basicValue5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue6 = values.get(1);
            if (basicValue6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onCompareTo(insn, (BoxedBasicValue)basicValue5, (BoxedBasicValue)basicValue6);
            value = value2;
        } else {
            this.markBoxedArgumentValues(values);
            value = value2;
        }
        return value;
    }

    private final void markBoxedArgumentValues(@NotNull List<? extends BasicValue> $receiver) {
        for (BasicValue basicValue : $receiver) {
            if (!(basicValue instanceof BoxedBasicValue)) continue;
            this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
        }
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.checkUsedValue(value);
        return insn.getOpcode() == 192 && this.isExactValue(value) ? value : super.unaryOperation(insn, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof ProgressionIteratorBasicValue) return true;
        if (value instanceof CleanBoxedValue) return true;
        if (value.getType() == null) return false;
        Type type2 = value.getType();
        Intrinsics.checkExpressionValueIsNotNull(type2, "value.type");
        if (!BoxingInterpreterKt.isProgressionClass(type2)) return false;
        return true;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v2, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull(v2, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        if (Intrinsics.areEqual(v2, StrictBasicValue.UNINITIALIZED_VALUE) || Intrinsics.areEqual(w, StrictBasicValue.UNINITIALIZED_VALUE)) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v2 instanceof BoxedBasicValue && w instanceof BoxedBasicValue) {
            this.onMergeSuccess((BoxedBasicValue)v2, (BoxedBasicValue)w);
            basicValue = v2 instanceof TaintedBoxedValue ? (BoxedBasicValue)v2 : (w instanceof TaintedBoxedValue ? (BoxedBasicValue)w : (Intrinsics.areEqual(((BoxedBasicValue)v2).getType(), ((BoxedBasicValue)w).getType()) ^ true ? ((BoxedBasicValue)v2).taint() : (BoxedBasicValue)v2));
        } else {
            basicValue = v2 instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)v2).taint() : (w instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)w).taint() : super.merge(v2, w));
        }
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resultType, "resultType");
    }

    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
    }

    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v2, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull(v2, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
    }

    public BoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkParameterIsNotNull(insnList, "insnList");
        Intrinsics.checkParameterIsNotNull(generationState, "generationState");
        this.insnList = insnList;
        this.generationState = generationState;
        this.boxingPlaces = new HashMap();
    }
}

