/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public class MessageLoggerEngine
implements MessageLogger {
    private final ThreadLocal loggerStacks = new ThreadLocal();
    private MessageLogger defaultLogger = null;
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    private Stack getLoggerStack() {
        Stack stack = (Stack)this.loggerStacks.get();
        if (stack == null) {
            stack = new Stack();
            this.loggerStacks.set(stack);
        }
        return stack;
    }

    public MessageLogger peekLogger() {
        if (this.getLoggerStack().isEmpty()) {
            return this.getDefaultLogger();
        }
        return (MessageLogger)this.getLoggerStack().peek();
    }

    private MessageLogger getDefaultLogger() {
        return this.defaultLogger == null ? Message.getDefaultLogger() : this.defaultLogger;
    }

    @Override
    public void warn(String msg) {
        this.peekLogger().warn(msg);
        this.problems.add("WARN:  " + msg);
        this.warns.add(msg);
    }

    @Override
    public void error(String msg) {
        this.peekLogger().error(msg);
        this.problems.add("\tERROR: " + msg);
        this.errors.add(msg);
    }

    public List getErrors() {
        return this.errors;
    }

    public List getProblems() {
        return this.problems;
    }

    public List getWarns() {
        return this.warns;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.getDefaultLogger().clearProblems();
        for (MessageLogger l : this.getLoggerStack()) {
            l.clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    @Override
    public void debug(String msg) {
        this.peekLogger().debug(msg);
    }

    @Override
    public void deprecated(String msg) {
        this.peekLogger().deprecated(msg);
    }

    @Override
    public void endProgress(String msg) {
        this.peekLogger().endProgress(msg);
    }

    @Override
    public void info(String msg) {
        this.peekLogger().info(msg);
    }

    @Override
    public void rawinfo(String msg) {
        this.peekLogger().rawinfo(msg);
    }

    @Override
    public void log(String msg, int level) {
        this.peekLogger().log(msg, level);
    }

    @Override
    public void progress() {
        this.peekLogger().progress();
    }

    @Override
    public void rawlog(String msg, int level) {
        this.peekLogger().rawlog(msg, level);
    }

    @Override
    public void verbose(String msg) {
        this.peekLogger().verbose(msg);
    }
}

