/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.utils.KotlinTypeBasedUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.EqualityLoweringType;
import org.jetbrains.kotlin.ir.backend.js.lower.EqualityOperator;
import org.jetbrains.kotlin.ir.backend.js.lower.IdentityOperator;
import org.jetbrains.kotlin.ir.backend.js.lower.IntrinsicifyCallsLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.IntrinsicifyCallsLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.RuntimeFunctionCall;
import org.jetbrains.kotlin.ir.backend.js.lower.RuntimeOrMethodCall;
import org.jetbrains.kotlin.ir.backend.js.lower.SimpleMemberKey;
import org.jetbrains.kotlin.ir.backend.js.utils.ConversionNames;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.backend.js.utils.OperatorNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazySymbolTable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010#\u001a\u00020\bH\u0002J\u0016\u0010$\u001a\u0004\u0018\u00010\b*\u00020%2\u0006\u0010&\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000ej\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000ej\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/IntrinsicifyCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "dynamicCallOriginToIrFunction", "", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "memberToTransformer", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/SimpleMemberKey;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/MemberToTransformer;", "nameToTransformer", "Lorg/jetbrains/kotlin/name/Name;", "symbolToTransformer", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/SymbolToTransformer;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformEqeqOperator", "call", "transformEqualsMethodCall", "transformRangeTo", "useDispatchReceiver", "withLongCoercion", "intrinsic", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/types/IrType;", "rhs", "backend.js"})
public final class IntrinsicifyCallsLowering
implements FileLoweringPass {
    private final JsIntrinsics intrinsics;
    private final IrBuiltIns irBuiltIns;
    private final Map<SimpleMemberKey, Function1<IrCall, IrExpression>> memberToTransformer;
    private final Map<IrFunctionSymbol, Function1<IrCall, IrExpression>> symbolToTransformer;
    private final Map<Name, Function1<IrCall, IrExpression>> nameToTransformer;
    private final Map<IrStatementOrigin, IrSimpleFunction> dynamicCallOriginToIrFunction;
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        irFile.transform(new IrElementTransformerVoid(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;

            @NotNull
            public <T> IrExpression visitConst(@NotNull IrConst<T> expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                if (expression2.getKind() instanceof IrConstKind.Long) {
                    IrCallImpl irCallImpl;
                    long value = ((Number)IrConstKind.Long.INSTANCE.valueOf(expression2)).longValue();
                    int high = (int)(value >> 32);
                    int low = (int)value;
                    IrCallImpl $receiver = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), IntrinsicifyCallsLowering.access$getIrBuiltIns$p(this.this$0).getLongType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getLongConstructor());
                    $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildInt(IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getIntType(), low));
                    $receiver.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getIntType(), high));
                    return irCallImpl;
                }
                if (expression2.getKind() instanceof IrConstKind.Char) {
                    IrCallImpl irCallImpl;
                    IrCallImpl $receiver = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), IntrinsicifyCallsLowering.access$getIrBuiltIns$p(this.this$0).getCharType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getCharConstructor());
                    $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildInt(IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getIntType(), ((Character)IrConstKind.Char.INSTANCE.valueOf(expression2)).charValue()));
                    return irCallImpl;
                }
                return super.visitConst(expression2);
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrExpression call2 = super.visitCall(expression2);
                if (call2 instanceof IrCall) {
                    IrSymbolOwner irSymbolOwner;
                    Object it;
                    Object object;
                    IrFunctionSymbol symbol2 = ((IrCall)call2).getSymbol();
                    IrFunction declaration = symbol2.getOwner();
                    if (IrUtilsKt.isDynamic(declaration) || IrUtilsKt.isEffectivelyExternal(declaration)) {
                        object = ((IrCall)call2).getOrigin();
                        if (Intrinsics.areEqual(object, IrStatementOrigin.GET_PROPERTY.INSTANCE)) {
                            IrLazySymbolTable irLazySymbolTable = IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getSymbolTable().getLazyWrapper();
                            FunctionDescriptor functionDescriptor = symbol2.getDescriptor();
                            if (functionDescriptor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
                            }
                            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty();
                            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "(symbol.descriptor as Pr\u2026or).correspondingProperty");
                            IrFieldSymbol fieldSymbol = irLazySymbolTable.referenceField(propertyDescriptor);
                            return JsIrBuilder.buildGetField$default(JsIrBuilder.INSTANCE, fieldSymbol, ((IrCall)call2).getDispatchReceiver(), null, call2.getType(), 4, null);
                        }
                        if (Intrinsics.areEqual(object, IrStatementOrigin.EQ.INSTANCE) && symbol2.getDescriptor() instanceof PropertyAccessorDescriptor) {
                            IrLazySymbolTable irLazySymbolTable = IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getSymbolTable().getLazyWrapper();
                            FunctionDescriptor functionDescriptor = symbol2.getDescriptor();
                            if (functionDescriptor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
                            }
                            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty();
                            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "(symbol.descriptor as Pr\u2026or).correspondingProperty");
                            IrFieldSymbol fieldSymbol = irLazySymbolTable.referenceField(propertyDescriptor);
                            IrExpression irExpression = call2;
                            IrCall $receiver = (IrCall)irExpression;
                            IrExpression irExpression2 = $receiver.getDispatchReceiver();
                            IrExpression irExpression3 = $receiver.getValueArgument(0);
                            if (irExpression3 == null) {
                                Intrinsics.throwNpe();
                            }
                            return JsIrBuilder.buildSetField$default(JsIrBuilder.INSTANCE, fieldSymbol, irExpression2, irExpression3, $receiver.getType(), null, 16, null);
                        }
                    }
                    if (IrUtilsKt.isDynamic(declaration)) {
                        object = IntrinsicifyCallsLowering.access$getDynamicCallOriginToIrFunction$p(this.this$0);
                        IrStatementOrigin fieldSymbol = ((IrCall)call2).getOrigin();
                        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object.get(fieldSymbol);
                        if (irSimpleFunction != null) {
                            it = object = irSimpleFunction;
                            return IntrinsicifyCallsLoweringKt.irCall$default((IrCall)call2, it.getSymbol(), true, false, 8, null);
                        }
                    }
                    Function1 function1 = (Function1)IntrinsicifyCallsLowering.access$getSymbolToTransformer$p(this.this$0).get(symbol2);
                    if (function1 != null) {
                        it = object = function1;
                        return (IrExpression)it.invoke(call2);
                    }
                    IrFunction irFunction = symbol2.getOwner();
                    if (!(irFunction instanceof IrFunction)) {
                        irFunction = irSymbolOwner = null;
                    }
                    if (irFunction != null && (irSymbolOwner = irSymbolOwner.getDispatchReceiverParameter()) != null) {
                        it = object = irSymbolOwner;
                        SimpleMemberKey key = new SimpleMemberKey(it.getType(), symbol2.getOwner().getName());
                        Function1 function12 = (Function1)IntrinsicifyCallsLowering.access$getMemberToTransformer$p(this.this$0).get(key);
                        if (function12 != null) {
                            Function1 function13;
                            Function1 it2 = function13 = function12;
                            return (IrExpression)it2.invoke(call2);
                        }
                        Void cfr_ignored_0 = (Void)null;
                    }
                    Function1 function14 = (Function1)IntrinsicifyCallsLowering.access$getNameToTransformer$p(this.this$0).get(symbol2.getOwner().getName());
                    if (function14 != null) {
                        it = object = function14;
                        return (IrExpression)it.invoke(call2);
                    }
                }
                return call2;
            }
            {
                this.this$0 = $outer;
            }
        }, null);
    }

    private final IrExpression useDispatchReceiver(IrCall call2) {
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        return irExpression;
    }

    private final IrExpression transformRangeTo(IrCall call2) {
        if (call2.getValueArgumentsCount() != 1) {
            return call2;
        }
        IrType irType = call2.getSymbol().getOwner().getValueParameters().get(0).getType();
        IrType $receiver = irType;
        return IrTypePredicatesKt.isByte($receiver) || IrTypePredicatesKt.isShort($receiver) || IrTypePredicatesKt.isInt($receiver) ? IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsNumberRangeToNumber(), true, false, 8, null) : (IrTypePredicatesKt.isLong($receiver) ? IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsNumberRangeToLong(), true, false, 8, null) : call2);
    }

    private final IrExpression transformEqeqOperator(IrCall call2) {
        IrCall irCall;
        IrExpression irExpression = call2.getValueArgument(0);
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        IrExpression lhs = irExpression;
        IrExpression irExpression2 = call2.getValueArgument(1);
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        IrExpression rhs = irExpression2;
        if (IrUtilsKt.isNullConst(lhs) || IrUtilsKt.isNullConst(rhs)) {
            return IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null);
        }
        EqualityLoweringType equalityLoweringType = IntrinsicifyCallsLoweringKt.translateEquals(lhs.getType(), rhs.getType());
        if (equalityLoweringType instanceof IdentityOperator) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeqeq().getSymbol(), false, false, 12, null);
        } else if (equalityLoweringType instanceof EqualityOperator) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null);
        } else if (equalityLoweringType instanceof RuntimeFunctionCall) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEquals(), false, false, 12, null);
        } else if (equalityLoweringType instanceof RuntimeOrMethodCall) {
            boolean bl;
            boolean bl2 = bl = !IrTypeUtilsKt.isNullable(lhs.getType());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            IrSimpleFunction equalsMethod = this.findEqualsMethod(lhs.getType(), rhs.getType());
            irCall = equalsMethod != null ? IntrinsicifyCallsLoweringKt.irCall$default(call2, equalsMethod.getSymbol(), false, true, 4, null) : IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEquals(), false, false, 12, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irCall;
    }

    private final IrSimpleFunction findEqualsMethod(@NotNull IrType $receiver, IrType rhs) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return null;
        }
        IrClassifierSymbol classifier2 = irClassifierSymbol;
        IrSymbolOwner irSymbolOwner = classifier2.getOwner();
        if (!(irSymbolOwner instanceof IrClass)) {
            irSymbolOwner = null;
        }
        IrClass irClass = (IrClass)irSymbolOwner;
        if (irClass == null) {
            return null;
        }
        Iterable iterable = irClass.getDeclarations();
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            if (!(Intrinsics.areEqual(it.getName(), Name.identifier("equals")) && it.getValueParameters().size() == 1 && KotlinTypeBasedUtilsKt.isSubtypeOf(rhs, it.getValueParameters().get(0).getType()) && !IrUtilsKt.isFakeOverriddenFromAny(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (IrSimpleFunction)CollectionsKt.maxWith((List)destination$iv$iv, findEqualsMethod.2.INSTANCE);
    }

    private final Function1<IrCall, IrExpression> withLongCoercion(IrSimpleFunction intrinsic) {
        return new Function1<IrCall, IrCall>(this, intrinsic){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            final /* synthetic */ IrSimpleFunction $intrinsic;

            @NotNull
            public final IrCall invoke(@NotNull IrCall call2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(call2, "call");
                boolean bl2 = bl = call2.getValueArgumentsCount() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrExpression irExpression = call2.getValueArgument(0);
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression arg = irExpression;
                IrExpression irExpression2 = call2.getDispatchReceiver();
                if (irExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                IrType receiverType = irExpression2.getType();
                if (IrTypePredicatesKt.isLong(arg.getType())) {
                    if (IrTypePredicatesKt.isDouble(receiverType)) {
                        IrCallImpl irCallImpl = new IrCallImpl(call2.getStartOffset(), call2.getEndOffset(), ((IrSimpleFunction)IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getLongToDouble().getOwner()).getReturnType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getLongToDouble());
                        int n = 0;
                        IrCall irCall = call2;
                        IrCallImpl $receiver = irCallImpl;
                        $receiver.setDispatchReceiver(arg);
                        IrCallImpl irCallImpl2 = irCallImpl;
                        irCall.putValueArgument(n, irCallImpl2);
                    } else if (IrTypePredicatesKt.isFloat(receiverType)) {
                        IrCallImpl irCallImpl = new IrCallImpl(call2.getStartOffset(), call2.getEndOffset(), ((IrSimpleFunction)IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getLongToFloat().getOwner()).getReturnType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getLongToFloat());
                        int n = 0;
                        IrCall irCall = call2;
                        IrCallImpl $receiver = irCallImpl;
                        $receiver.setDispatchReceiver(arg);
                        IrCallImpl irCallImpl3 = irCallImpl;
                        irCall.putValueArgument(n, irCallImpl3);
                    } else if (!IrTypePredicatesKt.isLong(receiverType)) {
                        IrCallImpl irCallImpl = new IrCallImpl(call2.getStartOffset(), call2.getEndOffset(), ((IrSimpleFunction)IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsNumberToLong().getOwner()).getReturnType(), IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsNumberToLong());
                        IrCall irCall = call2;
                        IrCallImpl $receiver = irCallImpl;
                        $receiver.putValueArgument(0, call2.getDispatchReceiver());
                        IrCallImpl irCallImpl4 = irCallImpl;
                        irCall.setDispatchReceiver(irCallImpl4);
                    }
                }
                return IrTypePredicatesKt.isLong(receiverType) ? call2 : IntrinsicifyCallsLoweringKt.irCall$default(call2, this.$intrinsic.getSymbol(), true, false, 8, null);
            }
            {
                this.this$0 = intrinsicifyCallsLowering;
                this.$intrinsic = irSimpleFunction;
                super(1);
            }
        };
    }

    private final IrExpression transformEqualsMethodCall(IrCall call2) {
        IrCall irCall;
        IrFunctionSymbol symbol2 = call2.getSymbol();
        IrFunction irFunction = symbol2.getOwner();
        if (!(irFunction instanceof IrFunction)) {
            irFunction = null;
        }
        if (irFunction == null) {
            return call2;
        }
        IrFunction function2 = irFunction;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            irValueParameter = function2.getExtensionReceiverParameter();
        }
        if (irValueParameter == null) {
            return call2;
        }
        IrValueParameter lhs = irValueParameter;
        IrExpression irExpression = call2.getValueArgument(0);
        if (irExpression == null) {
            return call2;
        }
        IrExpression rhs = irExpression;
        EqualityLoweringType equalityLoweringType = IntrinsicifyCallsLoweringKt.translateEquals(lhs.getType(), rhs.getType());
        if (equalityLoweringType instanceof IdentityOperator) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeqeq().getSymbol(), false, false, 12, null);
        } else if (equalityLoweringType instanceof EqualityOperator) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null);
        } else if (equalityLoweringType instanceof RuntimeFunctionCall) {
            irCall = IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEquals(), true, false, 8, null);
        } else if (equalityLoweringType instanceof RuntimeOrMethodCall) {
            irCall = IrUtilsKt.isFakeOverriddenFromAny(symbol2.getOwner()) ? (IrUtilsKt.isSuperToAny(call2) ? IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEqeqeq().getSymbol(), true, false, 8, null) : IntrinsicifyCallsLoweringKt.irCall$default(call2, this.intrinsics.getJsEquals(), true, false, 8, null)) : call2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irCall;
    }

    public IntrinsicifyCallsLowering(@NotNull JsIrBackendContext context) {
        IrType type22;
        Map<Object, Object> map2;
        Map map3;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.intrinsics = this.context.getIntrinsics();
        this.irBuiltIns = this.context.getIrBuiltIns();
        IntrinsicifyCallsLowering intrinsicifyCallsLowering = this;
        intrinsicifyCallsLowering.symbolToTransformer = map3 = (Map)new LinkedHashMap();
        intrinsicifyCallsLowering = this;
        intrinsicifyCallsLowering.memberToTransformer = map3 = (Map)new LinkedHashMap();
        intrinsicifyCallsLowering = this;
        intrinsicifyCallsLowering.nameToTransformer = map3 = (Map)new LinkedHashMap();
        intrinsicifyCallsLowering = this;
        intrinsicifyCallsLowering.dynamicCallOriginToIrFunction = map3 = (Map)new LinkedHashMap();
        Map<IrFunctionSymbol, Function1<IrCall, IrExpression>> $receiver = map2 = this.context.getIrBuiltIns();
        List<IrType> primitiveNumbers = CollectionsKt.listOf(((IrBuiltIns)((Object)$receiver)).getIntType(), ((IrBuiltIns)((Object)$receiver)).getShortType(), ((IrBuiltIns)((Object)$receiver)).getByteType(), ((IrBuiltIns)((Object)$receiver)).getFloatType(), ((IrBuiltIns)((Object)$receiver)).getDoubleType());
        $receiver = map2 = this.memberToTransformer;
        for (IrType type22 : primitiveNumbers) {
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, OperatorNames.INSTANCE.getUNARY_PLUS(), this.intrinsics.getJsUnaryPlus());
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, OperatorNames.INSTANCE.getUNARY_MINUS(), this.intrinsics.getJsUnaryMinus());
        }
        type22 = this.irBuiltIns.getStringType();
        Iterator<IrType> it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getADD(), this.intrinsics.getJsPlus());
        type22 = this.irBuiltIns.getIntType();
        it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getSHL(), this.intrinsics.getJsBitShiftL());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getSHR(), this.intrinsics.getJsBitShiftR());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getSHRU(), this.intrinsics.getJsBitShiftRU());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getAND(), this.intrinsics.getJsBitAnd());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getOR(), this.intrinsics.getJsBitOr());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getXOR(), this.intrinsics.getJsBitXor());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getINV(), this.intrinsics.getJsBitNot());
        type22 = this.irBuiltIns.getBooleanType();
        it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getAND(), this.intrinsics.getJsBitAnd());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getOR(), this.intrinsics.getJsBitOr());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getNOT(), this.intrinsics.getJsNot());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), OperatorNames.INSTANCE.getXOR(), this.intrinsics.getJsBitXor());
        type22 = this.irBuiltIns.getByteType();
        it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_BYTE(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_DOUBLE(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_FLOAT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_INT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_SHORT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_LONG(), this.intrinsics.getJsToLong());
        for (IrType type22 : CollectionsKt.listOf(this.irBuiltIns.getFloatType(), this.irBuiltIns.getDoubleType())) {
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_BYTE(), this.intrinsics.getJsNumberToByte());
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_DOUBLE(), new Function1<IrCall, IrExpression>(this){

                @NotNull
                public final IrExpression invoke(@NotNull IrCall p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
                }

                public final String getName() {
                    return "useDispatchReceiver";
                }

                public final String getSignature() {
                    return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }
            });
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_FLOAT(), new Function1<IrCall, IrExpression>(this){

                @NotNull
                public final IrExpression invoke(@NotNull IrCall p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
                }

                public final String getName() {
                    return "useDispatchReceiver";
                }

                public final String getSignature() {
                    return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }
            });
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_INT(), this.intrinsics.getJsNumberToInt());
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_SHORT(), this.intrinsics.getJsNumberToShort());
            IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, type22, ConversionNames.INSTANCE.getTO_LONG(), this.intrinsics.getJsNumberToLong());
        }
        type22 = this.irBuiltIns.getIntType();
        it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_BYTE(), this.intrinsics.getJsToByte());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_DOUBLE(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_FLOAT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_INT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_SHORT(), this.intrinsics.getJsToShort());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_LONG(), this.intrinsics.getJsToLong());
        type22 = this.irBuiltIns.getShortType();
        it = type22;
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_BYTE(), this.intrinsics.getJsToByte());
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_DOUBLE(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_FLOAT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_INT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_SHORT(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$useDispatchReceiver((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "useDispatchReceiver";
            }

            public final String getSignature() {
                return "useDispatchReceiver(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$op((Map)$receiver, (IrType)((Object)it), ConversionNames.INSTANCE.getTO_LONG(), this.intrinsics.getJsToLong());
        for (IrType type22 : primitiveNumbers) {
            Name name = Name.identifier("rangeTo");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"rangeTo\")");
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, name, new Function1<IrCall, IrExpression>(this){

                @NotNull
                public final IrExpression invoke(@NotNull IrCall p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return IntrinsicifyCallsLowering.access$transformRangeTo((IntrinsicifyCallsLowering)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
                }

                public final String getName() {
                    return "transformRangeTo";
                }

                public final String getSignature() {
                    return "transformRangeTo(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }
            });
        }
        $receiver = map2 = this.symbolToTransformer;
        IntrinsicifyCallsLoweringKt.access$add($receiver, (IrFunctionSymbol)this.irBuiltIns.getEqeqeqSymbol(), this.intrinsics.getJsEqeqeq());
        IntrinsicifyCallsLoweringKt.access$add($receiver, (IrFunctionSymbol)this.irBuiltIns.getEqeqSymbol(), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$transformEqeqOperator((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "transformEqeqOperator";
            }

            public final String getSignature() {
                return "transformEqeqOperator(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        IntrinsicifyCallsLoweringKt.access$add($receiver, this.irBuiltIns.getIeee754equalsFunByOperandType(), this.intrinsics.getJsEqeqeq());
        IntrinsicifyCallsLoweringKt.access$add($receiver, (IrFunctionSymbol)this.irBuiltIns.getBooleanNotSymbol(), this.intrinsics.getJsNot());
        IntrinsicifyCallsLoweringKt.access$add($receiver, this.irBuiltIns.getLessFunByOperandType(), this.intrinsics.getJsLt());
        IntrinsicifyCallsLoweringKt.access$add($receiver, this.irBuiltIns.getLessOrEqualFunByOperandType(), this.intrinsics.getJsLtEq());
        IntrinsicifyCallsLoweringKt.access$add($receiver, this.irBuiltIns.getGreaterFunByOperandType(), this.intrinsics.getJsGt());
        IntrinsicifyCallsLoweringKt.access$add($receiver, this.irBuiltIns.getGreaterOrEqualFunByOperandType(), this.intrinsics.getJsGtEq());
        $receiver = map2 = this.memberToTransformer;
        for (IrType type22 : primitiveNumbers) {
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getINC(), new Function1<IrCall, IrExpression>(this, primitiveNumbers){
                final /* synthetic */ IntrinsicifyCallsLowering this$0;
                final /* synthetic */ List $primitiveNumbers$inlined;
                {
                    this.this$0 = intrinsicifyCallsLowering;
                    this.$primitiveNumbers$inlined = list2;
                    super(1);
                }

                @NotNull
                public final IrExpression invoke(@NotNull IrCall it) {
                    IrCall irCall;
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    IrCall $receiver = irCall = IntrinsicifyCallsLoweringKt.irCall$default(it, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsPlus().getSymbol(), true, false, 8, null);
                    $receiver.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(IntrinsicifyCallsLowering.access$getIrBuiltIns$p(this.this$0).getIntType(), 1));
                    return irCall;
                }
            });
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getDEC(), new Function1<IrCall, IrExpression>(this, primitiveNumbers){
                final /* synthetic */ IntrinsicifyCallsLowering this$0;
                final /* synthetic */ List $primitiveNumbers$inlined;
                {
                    this.this$0 = intrinsicifyCallsLowering;
                    this.$primitiveNumbers$inlined = list2;
                    super(1);
                }

                @NotNull
                public final IrExpression invoke(@NotNull IrCall it) {
                    IrCall irCall;
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    IrCall $receiver = irCall = IntrinsicifyCallsLoweringKt.irCall$default(it, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsMinus().getSymbol(), true, false, 8, null);
                    $receiver.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(IntrinsicifyCallsLowering.access$getIrBuiltIns$p(this.this$0).getIntType(), 1));
                    return irCall;
                }
            });
        }
        for (IrType type22 : primitiveNumbers) {
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getADD(), this.withLongCoercion(this.intrinsics.getJsPlus()));
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getSUB(), this.withLongCoercion(this.intrinsics.getJsMinus()));
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getMUL(), this.withLongCoercion(this.intrinsics.getJsMult()));
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getDIV(), this.withLongCoercion(this.intrinsics.getJsDiv()));
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getMOD(), this.withLongCoercion(this.intrinsics.getJsMod()));
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, OperatorNames.INSTANCE.getREM(), this.withLongCoercion(this.intrinsics.getJsMod()));
        }
        for (IrType type22 : new IrType[]{this.irBuiltIns.getByteType(), this.irBuiltIns.getIntType()}) {
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, ConversionNames.INSTANCE.getTO_CHAR(), new Function1<IrCall, IrExpression>(this, primitiveNumbers){
                final /* synthetic */ IntrinsicifyCallsLowering this$0;
                final /* synthetic */ List $primitiveNumbers$inlined;
                {
                    this.this$0 = intrinsicifyCallsLowering;
                    this.$primitiveNumbers$inlined = list2;
                    super(1);
                }

                @NotNull
                public final IrExpression invoke(@NotNull IrCall it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return IntrinsicifyCallsLoweringKt.irCall$default(it, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getCharConstructor(), true, false, 8, null);
                }
            });
        }
        for (IrType type22 : new IrType[]{this.irBuiltIns.getFloatType(), this.irBuiltIns.getDoubleType()}) {
            IntrinsicifyCallsLoweringKt.access$op($receiver, type22, ConversionNames.INSTANCE.getTO_CHAR(), new Function1<IrCall, IrExpression>(this, primitiveNumbers){
                final /* synthetic */ IntrinsicifyCallsLowering this$0;
                final /* synthetic */ List $primitiveNumbers$inlined;
                {
                    this.this$0 = intrinsicifyCallsLowering;
                    this.$primitiveNumbers$inlined = list2;
                    super(1);
                }

                @NotNull
                public final IrExpression invoke(@NotNull IrCall it) {
                    IrCallImpl irCallImpl;
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    IrCallImpl $receiver = irCallImpl = new IrCallImpl(it.getStartOffset(), it.getEndOffset(), IntrinsicifyCallsLowering.access$getIrBuiltIns$p(this.this$0).getCharType(), IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getCharConstructor());
                    $receiver.putValueArgument(0, IntrinsicifyCallsLoweringKt.irCall$default(it, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsNumberToInt(), true, false, 8, null));
                    return irCallImpl;
                }
            });
        }
        IntrinsicifyCallsLoweringKt.access$op($receiver, this.irBuiltIns.getCharType(), ConversionNames.INSTANCE.getTO_CHAR(), 3.5.INSTANCE);
        $receiver = map2 = this.nameToTransformer;
        Name name = Name.special(Namer.INSTANCE.getKCALLABLE_GET_NAME());
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(Namer.KCALLABLE_GET_NAME)");
        IntrinsicifyCallsLoweringKt.access$addWithPredicate($receiver, name, new Function1<IrCall, Boolean>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            public final boolean invoke(@NotNull IrCall call2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(call2, "call");
                IrValueParameter irValueParameter = call2.getSymbol().getOwner().getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2;
                    IrValueParameter $receiver = irValueParameter2 = irValueParameter;
                    bl = KotlinTypeBasedUtilsKt.isSubtypeOfClass($receiver.getType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getKCallableClass());
                } else {
                    bl = false;
                }
                return bl;
            }
        }, new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getJsName().getSymbol(), true, false, 8, null);
            }
        });
        Name name2 = Name.identifier(Namer.INSTANCE.getKPROPERTY_GET());
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(Namer.KPROPERTY_GET)");
        IntrinsicifyCallsLoweringKt.access$addWithPredicate($receiver, name2, new Function1<IrCall, Boolean>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            public final boolean invoke(@NotNull IrCall call2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(call2, "call");
                IrValueParameter irValueParameter = call2.getSymbol().getOwner().getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2;
                    IrValueParameter $receiver = irValueParameter2 = irValueParameter;
                    bl = KotlinTypeBasedUtilsKt.isSubtypeOfClass($receiver.getType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getKPropertyClass());
                } else {
                    bl = false;
                }
                return bl;
            }
        }, new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getJsPropertyGet().getSymbol(), true, false, 8, null);
            }
        });
        Name name3 = Name.identifier(Namer.INSTANCE.getKPROPERTY_SET());
        Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(Namer.KPROPERTY_SET)");
        IntrinsicifyCallsLoweringKt.access$addWithPredicate($receiver, name3, new Function1<IrCall, Boolean>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            public final boolean invoke(@NotNull IrCall call2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(call2, "call");
                IrValueParameter irValueParameter = call2.getSymbol().getOwner().getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2;
                    IrValueParameter $receiver = irValueParameter2 = irValueParameter;
                    bl = KotlinTypeBasedUtilsKt.isSubtypeOfClass($receiver.getType(), IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIrBuiltIns().getKPropertyClass());
                } else {
                    bl = false;
                }
                return bl;
            }
        }, new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getContext$p(this.this$0).getIntrinsics().getJsPropertySet().getSymbol(), true, false, 8, null);
            }
        });
        Name name4 = Name.identifier("compareTo");
        Intrinsics.checkExpressionValueIsNotNull(name4, "Name.identifier(\"compareTo\")");
        IntrinsicifyCallsLoweringKt.access$addWithPredicate($receiver, name4, 4.7.INSTANCE, new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsCompareTo(), true, false, 8, null);
            }
        });
        Name name5 = Name.identifier("toString");
        Intrinsics.checkExpressionValueIsNotNull(name5, "Name.identifier(\"toString\")");
        $receiver.put((IrFunctionSymbol)((Object)name5), new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IntrinsicifyCallsLoweringKt.shouldReplaceToStringWithRuntimeCall(call2) ? (IrUtilsKt.isSuperToAny(call2) ? IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsAnyToString(), true, false, 8, null) : IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsToString(), true, false, 8, null)) : call2;
            }
        });
        Name name6 = Name.identifier("hashCode");
        Intrinsics.checkExpressionValueIsNotNull(name6, "Name.identifier(\"hashCode\")");
        $receiver.put((IrFunctionSymbol)((Object)name6), new Function1<IrCall, IrExpression>(this){
            final /* synthetic */ IntrinsicifyCallsLowering this$0;
            {
                this.this$0 = intrinsicifyCallsLowering;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrCall call2) {
                Intrinsics.checkParameterIsNotNull(call2, "call");
                return IrUtilsKt.isFakeOverriddenFromAny(call2.getSymbol().getOwner()) ? (IrUtilsKt.isSuperToAny(call2) ? IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsGetObjectHashCode(), true, false, 8, null) : IntrinsicifyCallsLoweringKt.irCall$default(call2, IntrinsicifyCallsLowering.access$getIntrinsics$p(this.this$0).getJsHashCode(), true, false, 8, null)) : call2;
            }
        });
        Name name7 = Name.identifier("equals");
        Intrinsics.checkExpressionValueIsNotNull(name7, "Name.identifier(\"equals\")");
        $receiver.put((IrFunctionSymbol)((Object)name7), new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return IntrinsicifyCallsLowering.access$transformEqualsMethodCall((IntrinsicifyCallsLowering)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IntrinsicifyCallsLowering.class);
            }

            public final String getName() {
                return "transformEqualsMethodCall";
            }

            public final String getSignature() {
                return "transformEqualsMethodCall(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        });
        $receiver = map2 = this.dynamicCallOriginToIrFunction;
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.EXCL.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsNot()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.LT.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsLt()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.GT.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsGt()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.LTEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsLtEq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.GTEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsGtEq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.EQEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsEqeq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.EQEQEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsEqeqeq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.EXCLEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsNotEq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.EXCLEQEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsNotEqeq()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.ANDAND.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsAnd()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.OROR.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsOr()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.UMINUS.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsUnaryMinus()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.UPLUS.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsUnaryPlus()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PLUS.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPlus()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.MINUS.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsMinus()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.MUL.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsMult()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.DIV.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsDiv()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PERC.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsMod()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PLUSEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPlusAssign()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.MINUSEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsMinusAssign()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.MULTEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsMultAssign()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.DIVEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsDivAssign()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PERCEQ.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsModAssign()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PREFIX_INCR.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPrefixInc()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.PREFIX_DECR.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPrefixDec()));
        $receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.POSTFIX_INCR.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPostfixInc()));
        IrSimpleFunction cfr_ignored_0 = (IrSimpleFunction)((Object)$receiver.put((IrFunctionSymbol)((Object)IrStatementOrigin.POSTFIX_DECR.INSTANCE), (Function1<IrCall, IrExpression>)((Object)this.context.getIntrinsics().getJsPostfixDec())));
    }

    @NotNull
    public static final /* synthetic */ IrBuiltIns access$getIrBuiltIns$p(IntrinsicifyCallsLowering $this) {
        return $this.irBuiltIns;
    }

    @NotNull
    public static final /* synthetic */ JsIrBackendContext access$getContext$p(IntrinsicifyCallsLowering $this) {
        return $this.context;
    }

    @NotNull
    public static final /* synthetic */ Map access$getDynamicCallOriginToIrFunction$p(IntrinsicifyCallsLowering $this) {
        return $this.dynamicCallOriginToIrFunction;
    }

    @NotNull
    public static final /* synthetic */ Map access$getSymbolToTransformer$p(IntrinsicifyCallsLowering $this) {
        return $this.symbolToTransformer;
    }

    @NotNull
    public static final /* synthetic */ Map access$getMemberToTransformer$p(IntrinsicifyCallsLowering $this) {
        return $this.memberToTransformer;
    }

    @NotNull
    public static final /* synthetic */ Map access$getNameToTransformer$p(IntrinsicifyCallsLowering $this) {
        return $this.nameToTransformer;
    }

    @NotNull
    public static final /* synthetic */ JsIntrinsics access$getIntrinsics$p(IntrinsicifyCallsLowering $this) {
        return $this.intrinsics;
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$useDispatchReceiver(IntrinsicifyCallsLowering $this, @NotNull IrCall call2) {
        return $this.useDispatchReceiver(call2);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$transformRangeTo(IntrinsicifyCallsLowering $this, @NotNull IrCall call2) {
        return $this.transformRangeTo(call2);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$transformEqeqOperator(IntrinsicifyCallsLowering $this, @NotNull IrCall call2) {
        return $this.transformEqeqOperator(call2);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$transformEqualsMethodCall(IntrinsicifyCallsLowering $this, @NotNull IrCall call2) {
        return $this.transformEqualsMethodCall(call2);
    }
}

