/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        Object baseExpression;
        IElementType operationToken = expression2.getOperationReference().getReferencedNameElementType();
        if (operationToken == KtTokens.EXCLEXCL) {
            KtExpression baseExpression2 = PsiUtils.getBaseExpression(expression2);
            JsExpression translatedExpression = Translation.translateAsExpression(baseExpression2, context);
            return TranslationUtils.sure(baseExpression2, translatedExpression, context);
        }
        if (operationToken == KtTokens.MINUS && (baseExpression = PsiUtils.getBaseExpression(expression2)) instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
            assert (compileTimeValue != null) : ErrorReportingUtils.message(expression2, "Expression is not compile time value: " + expression2.getText() + " ");
            Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression2, compileTimeValue);
            if (value instanceof Long) {
                return JsAstUtils.newLong((Long)value);
            }
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            return IncrementTranslator.translate(expression2, context);
        }
        baseExpression = TranslationUtils.translateBaseExpression(context, expression2);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression2, (JsExpression)baseExpression)) {
            return TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context.bindingContext());
        return CallTranslator.translate(context, resolvedCall2, (JsExpression)baseExpression);
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull KtUnaryExpression expression2, @NotNull JsExpression baseExpression) {
        if (PsiUtils.getOperationToken(expression2).equals(KtTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }
}

