/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File basedir) {
        this.setBasedir(basedir);
    }

    @Override
    public void setSettings(IvySettings settings) {
        this.settings = settings;
    }

    public File getResolutionCacheRoot() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public File getResolvedIvyFileInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    @Override
    public File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    @Override
    public File getConfigurationResolveReportInCache(String resolveId, String conf) {
        return new File(this.getResolutionCacheRoot(), resolveId + "-" + conf + ".xml");
    }

    @Override
    public void saveResolvedModuleDescriptor(ModuleDescriptor md) throws ParseException, IOException {
        ModuleRevisionId mrevId = md.getResolvedModuleRevisionId();
        File ivyFileInCache = this.getResolvedIvyFileInCache(mrevId);
        md.toIvyFile(ivyFileInCache);
        Properties paths = new Properties();
        this.saveLocalParents(mrevId, md, ivyFileInCache, paths);
        if (!paths.isEmpty()) {
            File parentsFile = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(mrevId, mrevId.getRevision() + "-parents"));
            FileOutputStream out = new FileOutputStream(parentsFile);
            paths.store(out, null);
            out.close();
        }
    }

    private void saveLocalParents(ModuleRevisionId baseMrevId, ModuleDescriptor md, File mdFile, Properties paths) throws ParseException, IOException {
        ExtendsDescriptor[] parents = md.getInheritedDescriptors();
        for (int i = 0; i < parents.length; ++i) {
            if (!parents[i].isLocal()) continue;
            ModuleDescriptor parent = parents[i].getParentMd();
            ModuleRevisionId pRevId = ModuleRevisionId.newInstance(baseMrevId, baseMrevId.getRevision() + "-parent." + paths.size());
            File parentFile = this.getResolvedIvyFileInCache(pRevId);
            parent.toIvyFile(parentFile);
            paths.setProperty(mdFile.getName() + "|" + parents[i].getLocation(), parentFile.getAbsolutePath());
            this.saveLocalParents(baseMrevId, parent, parentFile, paths);
        }
    }

    public String toString() {
        return this.name;
    }
}

