/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class PomModuleDescriptorBuilder {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static final Collection JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin", "jbi-component", "jbi-shared-library", "orbit", "hk2-jar");
    private final PomModuleDescriptor ivyModuleDescriptor;
    private ModuleRevisionId mrid;
    private DefaultArtifact mainArtifact;
    private ParserSettings parserSettings;

    public PomModuleDescriptorBuilder(ModuleDescriptorParser parser, Resource res, ParserSettings ivySettings) {
        this.ivyModuleDescriptor = new PomModuleDescriptor(parser, res);
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date(res.getLastModified()));
        for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
            this.ivyModuleDescriptor.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
        this.parserSettings = ivySettings;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String groupId, String artifactId, String version) {
        this.mrid = ModuleRevisionId.newInstance(groupId, artifactId, version);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
        if (version == null || version.endsWith("SNAPSHOT")) {
            this.ivyModuleDescriptor.setStatus("integration");
        } else {
            this.ivyModuleDescriptor.setStatus("release");
        }
    }

    public void setHomePage(String homePage) {
        this.ivyModuleDescriptor.setHomePage(homePage);
    }

    public void setDescription(String description) {
        this.ivyModuleDescriptor.setDescription(description);
    }

    public void setLicenses(License[] licenses) {
        for (int i = 0; i < licenses.length; ++i) {
            this.ivyModuleDescriptor.addLicense(licenses[i]);
        }
    }

    public void addMainArtifact(String artifactId, String packaging) {
        if ("pom".equals(packaging)) {
            DefaultArtifact artifact;
            ArtifactOrigin artifactOrigin;
            DependencyResolver resolver = this.parserSettings.getResolver(this.mrid);
            if (resolver != null && !ArtifactOrigin.isUnknown(artifactOrigin = resolver.locate(artifact = new DefaultArtifact(this.mrid, new Date(), artifactId, "jar", "jar")))) {
                this.mainArtifact = artifact;
                this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
            }
            return;
        }
        String ext = JAR_PACKAGINGS.contains(packaging) ? "jar" : ("pear".equals(packaging) ? "phar" : packaging);
        this.mainArtifact = new DefaultArtifact(this.mrid, new Date(), artifactId, packaging, ext);
        this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
    }

    public void addDependency(Resource res, PomReader.PomDependencyData dep) {
        List excluded;
        String version;
        String scope = dep.getScope();
        if (scope != null && scope.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(scope)) {
            scope = "compile";
        }
        version = (version = dep.getVersion()) == null || version.length() == 0 ? this.getDefaultVersion(dep) : version;
        ModuleRevisionId moduleRevId = ModuleRevisionId.newInstance(dep.getGroupId(), dep.getArtifactId(), version);
        ModuleRevisionId mRevId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (mRevId != null && mRevId.getModuleId().equals(moduleRevId.getModuleId())) {
            return;
        }
        PomDependencyDescriptor dd = new PomDependencyDescriptor(dep, this.ivyModuleDescriptor, moduleRevId);
        scope = scope == null || scope.length() == 0 ? this.getDefaultScope(dep) : scope;
        ConfMapper mapping = (ConfMapper)MAVEN2_CONF_MAPPING.get(scope);
        mapping.addMappingConfs(dd, dep.isOptional());
        HashMap<String, String> extraAtt = new HashMap<String, String>();
        if (dep.getClassifier() != null || dep.getType() != null && !"jar".equals(dep.getType())) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = type;
            if ("test-jar".equals(type)) {
                ext = "jar";
                extraAtt.put("m:classifier", "tests");
            } else if (JAR_PACKAGINGS.contains(type)) {
                ext = "jar";
            }
            if (dep.getClassifier() != null) {
                extraAtt.put("m:classifier", dep.getClassifier());
            }
            DefaultDependencyArtifactDescriptor depArtifact = new DefaultDependencyArtifactDescriptor(dd, dd.getDependencyId().getName(), type, ext, null, extraAtt);
            String optionalizedScope = dep.isOptional() ? "optional" : scope;
            dd.addDependencyArtifact(optionalizedScope, depArtifact);
        }
        if ((excluded = dep.getExcludedModules()).isEmpty()) {
            excluded = PomModuleDescriptorBuilder.getDependencyMgtExclusions(this.ivyModuleDescriptor, dep.getGroupId(), dep.getArtifactId());
        }
        for (ModuleId excludedModule : excluded) {
            String[] confs = dd.getModuleConfigurations();
            for (int k = 0; k < confs.length; ++k) {
                dd.addExcludeRule(confs[k], new DefaultExcludeRule(new ArtifactId(excludedModule, "*", "*", "*"), ExactPatternMatcher.INSTANCE, null));
            }
        }
        this.ivyModuleDescriptor.addDependency(dd);
    }

    public void addDependency(DependencyDescriptor descriptor) {
        ModuleId dependencyId = descriptor.getDependencyId();
        ModuleRevisionId mRevId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (mRevId != null && mRevId.getModuleId().equals(dependencyId)) {
            return;
        }
        this.ivyModuleDescriptor.addDependency(descriptor);
    }

    public void addDependencyMgt(PomDependencyMgt dep) {
        this.ivyModuleDescriptor.addDependencyManagement(dep);
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(dep.getGroupId(), dep.getArtifactId());
        this.overwriteExtraInfoIfExists(key, dep.getVersion());
        if (dep.getScope() != null) {
            String scopeKey = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(dep.getGroupId(), dep.getArtifactId());
            this.overwriteExtraInfoIfExists(scopeKey, dep.getScope());
        }
        if (!dep.getExcludedModules().isEmpty()) {
            String exclusionPrefix = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(dep.getGroupId(), dep.getArtifactId());
            int index = 0;
            for (ModuleId excludedModule : dep.getExcludedModules()) {
                this.overwriteExtraInfoIfExists(exclusionPrefix + index, excludedModule.getOrganisation() + "__" + excludedModule.getName());
                ++index;
            }
        }
        this.ivyModuleDescriptor.addDependencyDescriptorMediator(ModuleId.newInstance(dep.getGroupId(), dep.getArtifactId()), ExactPatternMatcher.INSTANCE, new OverrideDependencyDescriptorMediator(null, dep.getVersion()));
    }

    public void addPlugin(PomDependencyMgt plugin) {
        String pluginExtraInfo;
        String pluginValue = plugin.getGroupId() + "__" + plugin.getArtifactId() + "__" + plugin.getVersion();
        ExtraInfoHolder extraInfoByTagName = this.ivyModuleDescriptor.getExtraInfoByTagName("m:maven.plugins");
        if (extraInfoByTagName == null) {
            extraInfoByTagName = new ExtraInfoHolder();
            extraInfoByTagName.setName("m:maven.plugins");
            this.ivyModuleDescriptor.addExtraInfo(extraInfoByTagName);
        }
        pluginExtraInfo = (pluginExtraInfo = extraInfoByTagName.getContent()) == null ? pluginValue : pluginExtraInfo + "|" + pluginValue;
        extraInfoByTagName.setContent(pluginExtraInfo);
    }

    public static List getPlugins(ModuleDescriptor md) {
        ArrayList<PomPluginElement> result = new ArrayList<PomPluginElement>();
        String plugins = md.getExtraInfoContentByTagName("m:maven.plugins");
        if (plugins == null) {
            return new ArrayList();
        }
        String[] pluginsArray = plugins.split("\\|");
        for (int i = 0; i < pluginsArray.length; ++i) {
            String[] parts = pluginsArray[i].split("__");
            result.add(new PomPluginElement(parts[0], parts[1], parts[2]));
        }
        return result;
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        ModuleId moduleId = ModuleId.newInstance(dep.getGroupId(), dep.getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            return ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getVersion();
        }
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(dep.getGroupId(), dep.getArtifactId());
        return this.ivyModuleDescriptor.getExtraInfoContentByTagName(key);
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        String result;
        ModuleId moduleId = ModuleId.newInstance(dep.getGroupId(), dep.getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            result = ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getScope();
        } else {
            String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(dep.getGroupId(), dep.getArtifactId());
            result = this.ivyModuleDescriptor.getExtraInfoContentByTagName(key);
        }
        if (result == null || !MAVEN2_CONF_MAPPING.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private static String getDependencyMgtExtraInfoKeyForVersion(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + "__" + artifaceId + "__" + "version";
    }

    private static String getDependencyMgtExtraInfoKeyForScope(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + "__" + artifaceId + "__" + "scope";
    }

    private static String getPropertyExtraInfoKey(String propertyName) {
        return "m:properties__" + propertyName;
    }

    private static String getDependencyMgtExtraInfoPrefixForExclusion(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + "__" + artifaceId + "__" + "exclusion_";
    }

    private static List getDependencyMgtExclusions(ModuleDescriptor descriptor, String groupId, String artifactId) {
        PomDependencyMgt dependencyMgt;
        if (descriptor instanceof PomModuleDescriptor && (dependencyMgt = (PomDependencyMgt)((PomModuleDescriptor)descriptor).getDependencyManagementMap().get(ModuleId.newInstance(groupId, artifactId))) != null) {
            return dependencyMgt.getExcludedModules();
        }
        String exclusionPrefix = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(groupId, artifactId);
        LinkedList<ModuleId> exclusionIds = new LinkedList<ModuleId>();
        for (ExtraInfoHolder extraInfoHolder : descriptor.getExtraInfos()) {
            String key = extraInfoHolder.getName();
            if (!key.startsWith(exclusionPrefix)) continue;
            String fullExclusion = extraInfoHolder.getContent();
            String[] exclusionParts = fullExclusion.split("__");
            if (exclusionParts.length != 2) {
                Message.error("what seemed to be a dependency management extra info exclusion had the wrong number of parts (should have 2) " + exclusionParts.length + " : " + fullExclusion);
                continue;
            }
            exclusionIds.add(ModuleId.newInstance(exclusionParts[0], exclusionParts[1]));
        }
        return exclusionIds;
    }

    public static List getDependencyManagements(ModuleDescriptor md) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (md instanceof PomModuleDescriptor) {
            result.addAll(((PomModuleDescriptor)md).getDependencyManagementMap().values());
        } else {
            for (ExtraInfoHolder extraInfoHolder : md.getExtraInfos()) {
                String key = extraInfoHolder.getName();
                if (!key.startsWith("m:dependency.management")) continue;
                String[] parts = key.split("__");
                if (parts.length != 4) {
                    Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + key);
                    continue;
                }
                String versionKey = "m:dependency.management__" + parts[1] + "__" + parts[2] + "__" + "version";
                String scopeKey = "m:dependency.management__" + parts[1] + "__" + parts[2] + "__" + "scope";
                String version = md.getExtraInfoContentByTagName(versionKey);
                String scope = md.getExtraInfoContentByTagName(scopeKey);
                List exclusions = PomModuleDescriptorBuilder.getDependencyMgtExclusions(md, parts[1], parts[2]);
                result.add(new DefaultPomDependencyMgt(parts[1], parts[2], version, scope, exclusions));
            }
        }
        return result;
    }

    private void addExtraInfo(String key, String value) {
        if (this.ivyModuleDescriptor.getExtraInfoByTagName(key) == null) {
            this.ivyModuleDescriptor.getExtraInfos().add(new ExtraInfoHolder(key, value));
        }
    }

    private void overwriteExtraInfoIfExists(String key, String value) {
        boolean found = false;
        for (ExtraInfoHolder extraInfoHolder : this.ivyModuleDescriptor.getExtraInfos()) {
            if (!extraInfoHolder.getName().equals(key)) continue;
            extraInfoHolder.setContent(value);
            found = true;
        }
        if (!found) {
            this.ivyModuleDescriptor.getExtraInfos().add(new ExtraInfoHolder(key, value));
        }
    }

    public void addExtraInfos(List<ExtraInfoHolder> extraInfosHolder) {
        for (ExtraInfoHolder extraInfoHolder : extraInfosHolder) {
            this.addExtraInfo(extraInfoHolder.getName(), extraInfoHolder.getContent());
        }
    }

    public static Map extractPomProperties(List<ExtraInfoHolder> extraInfos) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (ExtraInfoHolder extraInfoHolder : extraInfos) {
            if (!extraInfoHolder.getName().startsWith("m:properties")) continue;
            String prop = extraInfoHolder.getName().substring("m:properties".length() + "__".length());
            r.put(prop, extraInfoHolder.getContent());
        }
        return r;
    }

    public void addProperty(String propertyName, String value) {
        this.addExtraInfo(PomModuleDescriptorBuilder.getPropertyExtraInfoKey(propertyName), value);
    }

    public Artifact getMainArtifact() {
        return this.mainArtifact;
    }

    public Artifact getSourceArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "sources"));
    }

    public Artifact getSrcArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "src"));
    }

    public Artifact getJavadocArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "javadoc", "jar", null, Collections.singletonMap("m:classifier", "javadoc"));
    }

    public void addSourceArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSourceArtifact());
    }

    public void addSrcArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSrcArtifact());
    }

    public void addJavadocArtifact() {
        this.ivyModuleDescriptor.addArtifact("javadoc", this.getJavadocArtifact());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("compile", "compile(*)");
                    dd.addDependencyConfiguration("compile", "master(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "runtime(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("provided", "compile(*)");
                    dd.addDependencyConfiguration("provided", "provided(*)");
                    dd.addDependencyConfiguration("provided", "runtime(*)");
                    dd.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("runtime", "compile(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                    dd.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("test", "runtime(*)");
                dd.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    public static class PomModuleDescriptor
    extends DefaultModuleDescriptor {
        private final Map dependencyManagementMap = new HashMap();

        public PomModuleDescriptor(ModuleDescriptorParser parser, Resource res) {
            super(parser, res);
        }

        public void addDependencyManagement(PomDependencyMgt dependencyMgt) {
            this.dependencyManagementMap.put(ModuleId.newInstance(dependencyMgt.getGroupId(), dependencyMgt.getArtifactId()), dependencyMgt);
        }

        public Map getDependencyManagementMap() {
            return this.dependencyManagementMap;
        }
    }

    public static class PomDependencyDescriptor
    extends DefaultDependencyDescriptor {
        private final PomReader.PomDependencyData pomDependencyData;

        private PomDependencyDescriptor(PomReader.PomDependencyData pomDependencyData, ModuleDescriptor moduleDescriptor, ModuleRevisionId revisionId) {
            super(moduleDescriptor, revisionId, true, false, true);
            this.pomDependencyData = pomDependencyData;
        }

        public PomReader.PomDependencyData getPomDependencyData() {
            return this.pomDependencyData;
        }
    }

    private static class PomPluginElement
    implements PomDependencyMgt {
        private String groupId;
        private String artifactId;
        private String version;

        public PomPluginElement(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

