/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PlatformUtils {
    private static final Set<String> COMMERCIAL_EDITIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("idea", "AppCode", "CLion", "Python", "Ruby", "PhpStorm", "WebStorm", "DataGrip", "Rider", "GoLand")));

    public static String getPlatformPrefix() {
        return PlatformUtils.getPlatformPrefix("idea");
    }

    public static String getPlatformPrefix(String defaultPrefix) {
        return System.getProperty("idea.platform.prefix", defaultPrefix);
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is("idea");
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is("Idea");
    }

    private static boolean is(String idePrefix) {
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }
}

